/*
ClientLDAP.cc
*/

#include "ClientLDAP.h"
extern Language *L;

#define LDAP_BIND_DN "uid=%s, dc=uv, dc=es"
#define DEFAULT_FILTER "(objectclass=*)"
#define FILTER_SERVICES "(&(objectClass=posixGroup)(memberUid=%s))"

ClientLDAP::ClientLDAP (const char *aserver, int aport, const char *auser, const char *apassword)
  {
  initStr (ErrorString);
  xstrncpy (server, CMAXIPNAME, aserver);
  xstrncpy (user, CMAXBUFFER, auser);
  xstrncpy (password, CMAXBUFFER, apassword);
  ldapport = aport;
  }  

ClientLDAP::~ClientLDAP ()
  {
  }

bool ClientLDAP::Authenticate ()
  {
  LDAP *ldap;
  int res, rc;
  TBuffer linea;
  
  ldap = ldap_init (server, ldapport);
  if (ldap == NULL) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  rc = LDAP_VERSION3;
  ldap_set_option (ldap, LDAP_OPT_PROTOCOL_VERSION, &rc);
  sprintf (linea, LDAP_BIND_DN, user);
  if (ldap_simple_bind_s (ldap, linea, password) != LDAP_SUCCESS) {ldap_perror (ldap, "ldap_simple_bind_s"); xstrncpy (ErrorString, CMAXBUFFER, L->get(ERR_INV_USER_PW)); return false;}

  res = ldap_unbind (ldap);
  return true;
  }

const char *ClientLDAP::getErrorMsg (void)
  {
  return ErrorString;           
  }  

bool ClientLDAP::SearchServices (const char *base)
  {
  LDAP *ldap;
  int res, rc;
  TBuffer linea, stfilter;
  char *attrs[2];
  LDAPMessage *result, *e; 
  char *dn, *attr, **vals;
  BerElement  *ber;

  ldap = ldap_init (server, ldapport);
  if (ldap == NULL) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  rc = LDAP_VERSION3;
  ldap_set_option (ldap, LDAP_OPT_PROTOCOL_VERSION, &rc);
  sprintf (linea, LDAP_BIND_DN, user);
  if (ldap_simple_bind_s (ldap, linea, password) != LDAP_SUCCESS) {ldap_perror (ldap, "ldap_simple_bind_s"); xstrncpy (ErrorString, CMAXBUFFER, L->get(ERR_INV_USER_PW)); return false;}

  sprintf (stfilter, FILTER_SERVICES, user);
  attrs[0] = NULL; 
  //LDAP_SCOPE_BASE LDAP_SCOPE_ONELEVEL LDAP_SCOPE_SUBTREE
  if (ldap_search_s (ldap, "ou=Groups, dc=uv, dc=es", LDAP_SCOPE_SUBTREE, 
                     "(&(objectClass=posixGroup)(memberUid=noprotes))", attrs, 0, &result) != LDAP_SUCCESS)
    {
    ldap_perror (ldap, "ldap_search_st");
    xstrncpy (ErrorString, CMAXBUFFER, "ldap_search_st"); 
    return false;
    }

   for (e = ldap_first_entry (ldap, result); e != NULL; e = ldap_next_entry(ldap, e) )
     {
     if ( (dn = ldap_get_dn(ldap, e)) != NULL)
       {
       DEBUG ("dn: %s\n", dn);
       ldap_memfree( dn );
       }
     for ( attr = ldap_first_attribute(ldap, e, &ber ); attr != NULL; attr = ldap_next_attribute(ldap, e, ber) )
       {
       if ( (vals = ldap_get_values(ldap, e, attr)) != NULL)
         {
         for (int i = 0; vals[i] != NULL; i++)
           {
           DEBUG( "%s: %s\n", attr, vals[i] );
           }
         ldap_value_free( vals);
         }
       ldap_memfree ( attr );
       }
     printf( "\n" );
     if ( ber != NULL )
       {
       ber_free ( ber, 0 );
       }
     }

  ldap_msgfree (result);     
  res = ldap_unbind (ldap);
  return true;
  }
