//*****************************************************************************
// copyright (c) 1998-2004 TLK Games all rights reserved
//-----------------------------------------------------------------------------
// file         : "score.hpp"
// created      : 1998-06-29
// updates      : 2004-08-01
//-----------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place - Suite 330, Boston, MA  02111-1307, USA.
//
//*****************************************************************************
#ifndef __SCORE__
#define __SCORE__
//..............................................................................
#include "chaine.hpp"
//..............................................................................
// texte a la commodore 64 (pour le ORDER)
const unsigned int      iTXT_NBRELIGNES=11;
const unsigned int      iTXT_NBRECOL=16;
const unsigned int      iTXT_FICHIERTAILLE=20480;              // taille utilise pour le fichier de commande (comportement du curseur)
const unsigned int      iTXT_PAUSE=0x4c1;                      // Pause code 
const unsigned int      iTXT_FIN=0x4c2;                        // end code 
                                  
// pour les scores proprement dit
const unsigned int      iMAXICARACTERES=100;                   // nombre maxium de caraceteres pour l'about
const unsigned int      iTABLEX1=128+32;                       // abscisse des noms
const unsigned int      iTABLEX2=128+96;                       // abscisse des scores
const unsigned int      iTABLEY=128+50;                        // ordonnee du premier nom
const unsigned int      iTABLEOFFSET=20;                       // espacement entre deux noms
const unsigned int      iNOMBRE_SCORES=5;                      // On garde cinq noms & cinq scores
const unsigned int      iLONGEURNOM=3;                         // Longeur nom du joueur 
const unsigned int      iTEMPOTABLE=400;                       // Temps d'apparition de la table avant d'afficher le GAME OVER
const unsigned int      iTOTALCARACTERES=iNOMBRE_SCORES*(iLONGEURNOM+8);
// Taille du fichier
const unsigned int      iTAILLEBUFFER=iNOMBRE_SCORES*(iLONGEURNOM+sizeof(int))+4;

class _score : public _chaine
{
  // Membres statiques
  private :
    static char                 pGameTexte[];                  // Texte ASCII
    static char                 pOverTexte[];                  // Texte ASCII
    static char                 pScoreTempo[32];               // tableau de travail
    static _chaine*             pChaineJoueur;                 // pointeur de type '_chaine' reservee a l'entree du nom du joueur
    static char                 cScoresNoms[iNOMBRE_SCORES][iLONGEURNOM+1];  // tableau contenant les noms en ASCII
    static int                  iScores[iNOMBRE_SCORES];       // tableau contenant les scores en entiers
    static _chaine*             pScoresObj;                    // tableau contenant les 10 chaines noms & scores
    static int                  iAction ;                      // 0=pas d'action / 1=entre score / 6=affiche table score
    static int                  iActionExecution ;             // 0=pas d'action / 1=entre score / 6=affiche table score
    static _chaine*             pGame;
    static _chaine*             pOver;
    static unsigned int         iTempo;                        // >0 le joueur n'est pas dans les scores, la table apparait un instant
    static int                  iLettreAnime;                  // numero de la lettre anime !
    static _caractere*          pLettreActuelle;
    static _caractere*          pTableau[iTOTALCARACTERES];

    static _caractere*          pTexteAbout;
    static char*                pTableAbout[];                 // Liste des textes du "ABOUT"
    static unsigned int         iAboutNombreCaracteres;        // Nombre de caracteres affichees a un moment donne du "ABOUT"
    static unsigned int         iIndexAboutTable;              // Index sur la liste des textes de du "ABOUT"
    static unsigned int         iAnimIndex;                    // Numero du caractere a anime
    static unsigned int         iAnimIndexTempo;

    // Texte a la commmodore 64
    static _chaine*             pTxtChaines;
    static int                  iTxtPosX;
    static unsigned int         iTxtPosY;
    static char*                pTxtTableau;
    static unsigned short      *pTableCommande;                // tableau contenant le texte & mouvement du curseur
    static unsigned int         iTableIndex;                   // index sur le tableau 'pTableCommande'
    static int                  iTableTempo;                   // compteur d'attente entre chaque action (maximum=255)

  // Methodes statiques
  public :
    static int                  getActionExecution();
    static void                 execution(int _bFlag);
    static int                  setAction(int _iCodeAction);
    static int                  isInputName();
    static void                 destroy();
  private :
    static int                  initialiseGameOver(int _iPosition);
    static int                  creeScores();
    static int                  creeAbout();
    static int                  creeOrder();
    static int                  affScores();
    static void                 animationScore();
    static int                  trieScores();
    static int                  chargeScores();
    static void                 sauveScores();
    static void                 creeNouvelleTable();
    static int                  calculSomme(int* _pBuffer, int _iTaille);
    static void                 afficheScores();
    static void                 executeGameOver(int _iFlag);
    static void                 executeTableScore(int _iFlag);
    static void                 executeAbout(int _iFlag);
    static void                 executeOrder(int _iFlag);
    static void                 effaceCaracteres();    
    static void                 insertLigne(int _iLigne);
    static void                 supprimeLigne(int _iLigne);
    static int                  chargeTable();
    static void                 sauveTable();
    static void                 entreTableValeur(unsigned short cValeur);
    static unsigned short       sortTableValeur();
    static void                 testApparitionMenu();
};
#endif
