/* ----------------------------------------------------------------------------
 * taghandler.c
 * funtions to get tagdata from and set tagdata to widgets
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include <pbb.h>

#include "init.h"
#include "taghandler.h"
#include "support.h"

extern struct basedata masterdata;

long
th_showtext (int mode, long tag, GtkWidget *widget, long data)
{
	if (mode == THMODE_SET)
		gtk_label_set_text(GTK_LABEL(widget), (gchar*) data);
	return data;
}

long
th_showvalue (int mode, long tag, GtkWidget *widget, long data)
{
	char buffer[10];

	if (mode == THMODE_SET) {
		snprintf(buffer, sizeof(buffer)-1, "%ld", data);
		gtk_label_set_text(GTK_LABEL(widget), (gchar*) buffer);
	}
	return data;
}

long
th_textentry (int mode, long tag, GtkWidget *widget, long data)
{
	if (mode == THMODE_SET)
		gtk_entry_set_text(GTK_ENTRY(widget), (gchar*) data);
	else
		data = (long) gtk_entry_get_text(GTK_ENTRY(widget));
	return data;
}

long
th_checkbox (int mode, long tag, GtkWidget *widget, long data)
{
	if (mode == THMODE_SET)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (widget), data ? TRUE : FALSE);
	else
		data = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
	return data ? 1 : 0;
}

long
th_radiobutton (int mode, long tag, GtkWidget *widget, long data)
{
	GSList *radiolist;
	int n;

	if (mode == THMODE_SET) {
		radiolist = gtk_radio_button_get_group (GTK_RADIO_BUTTON(widget));
		if (g_slist_length(radiolist) > data) {
			for(n=g_slist_length(radiolist)-1; n > data; n--)
				radiolist = g_slist_next(radiolist);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (radiolist->data), TRUE);
		}
	} else {
		radiolist = gtk_radio_button_get_group (GTK_RADIO_BUTTON(widget));
		for(n=g_slist_length(radiolist)-1; n > 0; n--) {
			if ((gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(radiolist->data))) == TRUE)
				return n;
			radiolist = g_slist_next(radiolist);
		}
	}
	return data;
}

long
th_keyentry (int mode, long tag, GtkWidget *widget, long data)
{
	int key, mod;
	char arg[25];

	if (mode == THMODE_SET) {
		strncpy (arg, (char*) gtk_entry_get_text(GTK_ENTRY(widget)), sizeof(arg));
		get_key_and_modifier(arg, &key, &mod);
		gtk_entry_set_text(GTK_ENTRY(widget), code_key_and_modifier(data, mod));
	} else {
		strncpy (arg, (char*) gtk_entry_get_text(GTK_ENTRY(widget)), sizeof(arg));
		get_key_and_modifier(arg, &key, &mod);
		data = key;
	}
	return data;
}

long
th_modentry (int mode, long tag, GtkWidget *widget, long data)
{
	int key, mod;
	char arg[25];

	if (mode == THMODE_SET) {
		strncpy (arg, (char*) gtk_entry_get_text(GTK_ENTRY(widget)), sizeof(arg));
		get_key_and_modifier(arg, &key, &mod);
		gtk_entry_set_text(GTK_ENTRY(widget), code_key_and_modifier(key, data));
	} else {
		strncpy (arg, (char*) gtk_entry_get_text(GTK_ENTRY(widget)), sizeof(arg));
		get_key_and_modifier(arg, &key, &mod);
		data = mod;
	}
	return data;
}

long
th_spinbutton (int mode, long tag, GtkWidget *widget, long data)
{
	if (mode == THMODE_SET)
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget), (gdouble) data);
	else
		data = (long) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));
	return data;
}

long
th_system (int mode, long tag, GtkWidget *widget, long data)
{
	struct basedata *base = (struct basedata*) &masterdata;
	GtkWidget *wid;

	switch(tag) {
		case TAG_SYSINFO:
			if (mode == THMODE_SET) {				
				/* disable sleep functions if sleep is not available */
				if ((data & SYSINFO_SLEEPSUPPORTED) == 0) {
					if ((wid = lookup_widget(base->mainwindow, "pv_radio_ema")))
						gtk_widget_set_sensitive (wid, FALSE);
					if ((wid = lookup_widget(base->mainwindow, "pv_radio_sleep")))
						gtk_widget_set_sensitive (wid, FALSE);
					if ((wid = lookup_widget(base->mainwindow, "pv_radio_coversleep")))
						gtk_widget_set_sensitive (wid, FALSE);
				}
				
				/* hide pmud text if server is compiled without pmud support */
				if ((data & SYSINFO_PMUDSUPPORT) == 0)
					if ((wid = lookup_widget(base->mainwindow, "ab_itext_pmud")))
						gtk_widget_hide (wid);
				
				/* disable keyboard illumination and autoadjustment notetabs
				 * if a LMU is not available
				 */
				if ((data & SYSINFO_HAVELMU) == 0) {
					if ((wid = lookup_widget(base->mainwindow, "vi_func_keyboardtab")))
						gtk_widget_set_sensitive (wid, FALSE);
					if ((wid = lookup_widget(base->mainwindow, "vi_func_keyboardlab")))
						gtk_widget_set_sensitive (wid, FALSE);
					if ((wid = lookup_widget(base->mainwindow, "vi_func_autoadjtab")))
						gtk_widget_set_sensitive (wid, FALSE);
					if ((wid = lookup_widget(base->mainwindow, "vi_func_autoadjlab")))
						gtk_widget_set_sensitive (wid, FALSE);
				}
				
				/* disable button if server does not allow writing of configfile */
				if ((data & SYSINFO_CONFIGWRITABLE) == 0)
					if ((widget = lookup_widget(base->mainwindow, "main_btn_save")))
						gtk_widget_set_sensitive (widget, FALSE);
			}
			break;
	}
	return data;
}

long
th_profile (int mode, long tag, GtkWidget *widget, long data)
{
	struct basedata *base = (struct basedata*) &masterdata;
	switch(tag) {
		case TAG_ONACSLEEP:
			if (mode)	base->ac.flags.sleep = data;
			else		data = base->ac.flags.sleep;
			break;
		case TAG_ONACDIM:
			if (mode)	base->ac.flags.dim = data;
			else		data = base->ac.flags.dim;
			break;
		case TAG_ONACCOVERSLEEP:
			if (mode)	base->ac.flags.coversleep = data;
			else		data = base->ac.flags.coversleep;
			break;
		case TAG_ONACTIMESLEEP:
			if (mode)	base->ac.Tsleep = (long) data / 10;
			else		data = base->ac.Tsleep * 10;
			break;
		case TAG_ONACTIMEDIM:
			if (mode)	base->ac.Tdim = (long) data / 10;
			else		data = base->ac.Tdim * 10;
			break;
		case TAG_ONACTIMEHDOFF:
			if (mode)	base->ac.Thdoff = data * 5;
			else		data = (long) (base->ac.Thdoff / 5);
			break;
		case TAG_ONBATTERYSLEEP:
			if (mode)	base->battery.flags.sleep = data;
			else		data = base->battery.flags.sleep;
			break;
		case TAG_ONBATTERYDIM:
			if (mode)	base->battery.flags.dim = data;
			else		data = base->battery.flags.dim;
			break;
		case TAG_ONBATTERYCOVERSLEEP:
			if (mode)	base->battery.flags.coversleep = data;
			else		data = base->battery.flags.coversleep;
			break;
		case TAG_ONBATTERYTIMESLEEP:
			if (mode)	base->battery.Tsleep = (long) data / 10;
			else		data = base->battery.Tsleep * 10;
			break;
		case TAG_ONBATTERYTIMEDIM:
			if (mode)	base->battery.Tdim = (long) data / 10;
			else		data = base->battery.Tdim * 10;
			break;
		case TAG_ONBATTERYTIMEHDOFF:
			if (mode)	base->battery.Thdoff = data * 5;
			else		data = (long) (base->battery.Thdoff / 5);
			break;
	}

	if (mode == THMODE_SET)
		update_profile_gui();
	return data;
}

long
th_dummy (int mode, long tag, GtkWidget *widget, long data)
{
	return data;
}

void
update_profile_gui()
{
	struct basedata *base = (struct basedata*) &masterdata;
	GtkWidget *widget;

	if ((widget = lookup_widget(base->mainwindow, "pv_radio_sleep")))
		(void) th_radiobutton (THMODE_SET, 0, widget, (!base->profile->flags.sleep) & 1);
	if ((widget = lookup_widget(base->mainwindow, "pv_check_dim")))
		(void) th_checkbox (THMODE_SET, 0, widget, base->profile->flags.dim);
	if ((widget = lookup_widget(base->mainwindow, "pv_radio_coversleep")))
		(void) th_radiobutton (THMODE_SET, 0, widget, (!base->profile->flags.coversleep) & 1);
	if ((widget = lookup_widget(base->mainwindow, "pv_spin_sleeptime")))
		(void) th_spinbutton (THMODE_SET, 0, widget, base->profile->Tsleep);
	if ((widget = lookup_widget(base->mainwindow, "pv_spin_dimtime")))
		(void) th_spinbutton (THMODE_SET, 0, widget, base->profile->Tdim);
	if ((widget = lookup_widget(base->mainwindow, "pv_spin_hdofftime")))
		(void) th_spinbutton (THMODE_SET, 0, widget, base->profile->Thdoff);
}

void
get_key_and_modifier(char *arg, int *key, int *mod)
{
	char *tag;
	int k;

	*mod = 0; *key = 0;
	tag = strtok(arg, "+\n");
	while (tag) {
		k = atoi (tag) & 255;
		if (k == 0) {
			while (*tag == ' ') tag++;   /* ignore leading spaces */
			if (!strncmp("shift", tag, 5))
				*mod |= MOD_SHIFT;
			else if (!strncmp("alt", tag, 3))
				*mod |= MOD_ALT;
			else if (!strncmp("ctrl", tag, 4))
				*mod |= MOD_CTRL;
		} else
			*key = k;
		tag = strtok(0, "+\n");
	}
}

char*
code_key_and_modifier (int key, int mod)
{
	static char buffer[30];

	snprintf (buffer, sizeof(buffer)-1, "%d", (key & 255));
	if (mod & MOD_SHIFT)
		strcat (buffer, " + shift");
	if (mod & MOD_ALT)
		strcat (buffer, " + alt");
	if (mod & MOD_CTRL)
		strcat (buffer, " + ctrl");
	return buffer;
}
