#ifndef INCLUDE_CALLBACKS_H
#define INCLUDE_CALLBACKS_H
/* ----------------------------------------------------------------------------
 * callbacks.h
 * prototypes and definitions for callbacks.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <gtk/gtk.h>
#include "init.h"

void cb_apply_clicked (GtkWidget *window, gpointer user_data);
void cb_save_clicked (GtkWidget *window, gpointer user_data);
void cb_reset_clicked (GtkButton *button, gpointer user_data);
void cb_hidewidget (GtkWidget *widget, gpointer user_data);
void cb_profile_changed (GtkWidget *window, gpointer user_data);
void cb_update_profile (GtkWidget *widget, gpointer user_data);
void cb_start_learn (GtkWidget *widget, struct basedata *base);
gboolean cb_mainwindow_moved (GtkWidget *widget, GdkEventConfigure *event, struct basedata *base);
void cb_learnwindow_show (GtkWidget *widget, struct basedata *base);
void cb_keyboard_handler (struct basedata *base, int fd, GdkInputCondition ic);

int track_modifier(struct basedata *base, unsigned short code, unsigned int value);
int filter_keycode(unsigned short code);

#endif    /* INCLUDE_CALLBACKS_H */

