#!/bin/bash
#
# Test if a harddisk supports APM and / or AAM
# must be run as root.
# Stefan Seyfried <seife@suse.de>
#
DEV=$1
[ -z "$DEV" ] && echo "please specify a device (hda, hdb...)" && exit 1

X=`cat /proc/ide/$DEV/identify` || exit 1 # this concatenates all lines...
set $X
#
# now $1 is word00, $2 is word01... $84 is word83

# bit 9 of word 83 is AAM
if [ $[0x${84} & 0x0200 ] -ne 0 ] ; then
   echo "AAM supported"
else
   echo "AAM unsupported"
fi

# bit 3 of word 83 is APM
if [ $[0x${84} & 0x08 ] -ne 0 ] ; then
   echo "APM supported"
else
   echo "APM unsupported"
fi
