/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *      Parts copyright 2003 John Knottenbelt, taken from dvbd-0.7.7       *
 *                      2005 Stefan Seyfried                               *
 *                                                                         *
 *               Author(s): John Knottenbelt                               *
 *                          Stefan Seyfried                                *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#if !defined __STRING_UTIL_H
#define __STRING_UTIL_H

#include <string>
#include <vector>
#include <ctime>

std::string toString(bool b);
std::string toString(int n);
std::string toString(unsigned n);
std::string toString(double n);
std::string lowercase(const std::string & s);
int toPosInt(const std::string & s);
unsigned toUnsigned(const std::string & s);
unsigned long toUnsignedLong(const std::string & s);
double toDouble(const std::string & s);
bool toBool(const std::string & s);

void splitString(const std::string & s, char delim, std::vector < std::string > &v);
std::string stripLeadingWS(const std::string & s);
std::string stripLineComment(const std::string & s, char delim = '#');
std::string stripTrailingWS(const std::string & s);
std::string stripApostrophe(const std::string & s);

#endif				// __STRING_UTIL_H
