#!/bin/bash
#
# convert powersave configuration files from version
# 0.9 to 0.10 or greater. We dropped the (inconsistently used)
# prefixes POWERSAVE_ and POWERSAVED_ and renamed the following
# variables:
#     POWERSAVE_EVENT_PROCESSOR_DYNAMIC_HIGH => EVENT_PROCESSOR_BUSY
#     POWERSAVE_EVENT_PROCESSOR_DYNAMIC_LOW  => EVENT_PROCESSOR_IDLE
#     POWERSAVED_DYNAMIC_LOW_CPU_LIMIT       => PROCESSOR_IDLE_LIMIT

PSCONF=/etc/sysconfig/powersave
BACKUP=$PSCONF/.backup_pre-0.10 # must start with a dot.

if [ ! -e $PSCONF/common ]; then
    # nothing to do...
    exit 0
fi

CONFIG_VERSION=0
. $PSCONF/common
if [ "$CONFIG_VERSION" -ge 10 ]; then
    # nothing to do...
    exit 0
fi

if [ -e $BACKUP ]; then
    # we already ran but did not update correctly. Should not happen.
    echo "directory /etc/sysconfig/powersave/backup_pre_0.10 already exists"
    DIR=`mktemp -d ${BACKUP}_XXXXXX`
    if [ -z "$DIR" ]; then
        echo "could not create tempdir for backup of config"
        exit 1
    fi
    mv $BACKUP/* $DIR/
else
    mkdir -p $BACKUP
fi

mv $PSCONF/* $BACKUP/

cd $BACKUP/
for i in *; do
    sed 's/POWERSAVED\?_//;
         s/EVENT_PROCESSOR_DYNAMIC_HIGH/EVENT_PROCESSOR_BUSY/;
         s/EVENT_PROCESSOR_DYNAMIC_LOW/EVENT_PROCESSOR_IDLE/;
         s/DYNAMIC_LOW_CPU_LIMIT/PROCESSOR_IDLE_LIMIT/' $i > $PSCONF/$i
done
