/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *             Copyright (C) 2005 SUSE Linux Products GmbH                 *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef POWERSAVE_GLOBALS_H
#define POWERSAVE_GLOBALS_H

class PM_Interface;
class GeneralConfig;
class CpufreqManagement;
class MainLoop;

namespace Powersave {

	namespace Globals {
		
		/** @brief global object
		 *         must be declared extern to let DBus functions
		 *         be able to access the handleDBusRequest function
		 */
		extern PM_Interface *pm;
		
		/** @brief global configuration object */
		extern GeneralConfig *config_obj;
		
		/** @brief global cpufreq object */
		extern CpufreqManagement *cpufreq;
		
		/** @brief global MainLoop object */
		extern MainLoop *main_loop;
	};

};

	
#endif
