  /*  prefs-colors.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

gint last_scheme, last_fgbg;

GtkWidget * cs_hbox1, * cs_hbox2, * cs_vbox1, * cs_vbox2;
GtkWidget * cs_vbox3, * cs_vbox4, * cs_vbox5;

GtkWidget * cs_dropscheme, * cs_dropfgbg;

GtkWidget * cs_schememenu, * cs_fgbgmenu;
GtkWidget * cs_schemelabel, * cs_fgbglabel, * cs_fglabel, * cs_bglabel;

GtkWidget * color_table, * color_table2;
GtkWidget * color_pickers[18];

GtkWidget * menus[8];

void color_menu_event (GtkMenuItem * w, gpointer data)
{
  int a;
  int changed = 0;
  int fgbg_changed = 0;

  switch ((int)data)
    {
    case 1:
      for (a=0;a<16;a++)
	{
	  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				      linux_red[a], linux_grn[a],
				      linux_blu[a], 0);

	  gtk_widget_set_sensitive (color_pickers[a], FALSE);
	  changed = 1;
	  last_scheme = PALETTE_LINUX;
	}
      break;

    case 2:
      for (a=0;a<16;a++)
	{
	  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				      xterm_red[a], xterm_grn[a],
				      xterm_blu[a], 0);


	  gtk_widget_set_sensitive (color_pickers[a], FALSE);
	  changed = 1;
	  last_scheme = PALETTE_XTERM;
	}
      break;
    case 3:
      for (a=0;a<16;a++)
	{
	  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				      rxvt_red[a], rxvt_grn[a],
				      rxvt_blu[a], 0);

	  gtk_widget_set_sensitive (color_pickers[a], FALSE);
	  changed = 1;
	  last_scheme = PALETTE_RXVT;
	}

      break;

    case 4:
      for (a=0;a<16;a++)
	{
	  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				      ColorPrefs.red[a], ColorPrefs.green[a],
				      ColorPrefs.blue[a], 0);
  
	  gtk_widget_set_sensitive (color_pickers[a], TRUE);
	}      
      last_scheme = PALETTE_CUSTOM;
      changed = 1;
      break;



    case 101:
      gtk_widget_set_sensitive (color_pickers[16], FALSE);
      gtk_widget_set_sensitive (color_pickers[17], FALSE);

      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
				  0xffff, 0xffff, 0xffff, 0);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
				  0, 0, 0, 0);
      
      fgbg_changed = 1;
      break;

    case 102:

      gtk_widget_set_sensitive (color_pickers[16], FALSE);
      gtk_widget_set_sensitive (color_pickers[17], FALSE);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
				  0, 0, 0, 0);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
				  0xffff, 0xffff, 0xffff, 0);
      fgbg_changed = 1;
      break;

    case 103:

      ColorPrefs.fg[0] = 0;
      ColorPrefs.fg[1] = 0xffff;
      ColorPrefs.fg[2] = 0;

      ColorPrefs.bg[0] = 0;      
      ColorPrefs.bg[1] = 0;     
      ColorPrefs.bg[2] = 0;

      gtk_widget_set_sensitive (color_pickers[16], FALSE);
      gtk_widget_set_sensitive (color_pickers[17], FALSE);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
				  0, 0xffff, 0, 0);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
				  0, 0, 0, 0);
      fgbg_changed = 1;
      break;

    case 104:
      gtk_widget_set_sensitive (color_pickers[16], TRUE);
      gtk_widget_set_sensitive (color_pickers[17], TRUE);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
				  ColorPrefs.fg[0], ColorPrefs.fg[1], ColorPrefs.fg[2], 0);
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
				  ColorPrefs.bg[0], ColorPrefs.bg[1], ColorPrefs.bg[2], 0);
      fgbg_changed = 1;
      break;
    }

  if (changed)
    {
      property_changed (GTK_WIDGET(w), NULL);
    }
    
  if (fgbg_changed)
    {
      property_changed (GTK_WIDGET(w), NULL);
    }
  
}

int ApplyPrefsColors ()
{
  GtkWidget * menu_item;

  int a;
  gushort dummy;

  menu_item = gtk_menu_get_active (GTK_MENU(cs_schememenu));
  ColorPrefs.palette = last_scheme;
  for (a=0;a<16;a++)
    {
      gnome_color_picker_get_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				  &ColorPrefs.red[a], &ColorPrefs.green[a], &ColorPrefs.blue[a], &dummy);
    }
  
  gnome_color_picker_get_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
			      (gushort *)&ColorPrefs.fg[0], (gushort *)&ColorPrefs.fg[1], 
			      (gushort *)&ColorPrefs.fg[2], &dummy);
 
  gnome_color_picker_get_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
			      (gushort *)&ColorPrefs.bg[0], (gushort *)&ColorPrefs.bg[1], 
			      (gushort *)&ColorPrefs.bg[2], &dummy);

 
}

int CreatePrefsColors (GtkContainer * area)
{
  int a;
  int bscheme, bfgbg;

  cs_hbox1 = gtk_hbox_new (TRUE, 10);
  cs_hbox2 = gtk_hbox_new (TRUE, 10);
  cs_vbox1 = gtk_vbox_new (FALSE, 0);
  cs_vbox2 = gtk_vbox_new (FALSE, 0);

  cs_vbox3 = gtk_vbox_new (FALSE, 0);
  cs_vbox4 = gtk_vbox_new (FALSE, 0);
  cs_vbox5 = gtk_vbox_new (TRUE, 10);

  color_table = gtk_table_new (2, 8, TRUE);
  color_table2 = gtk_table_new (2, 8, TRUE);

  cs_schemelabel = gtk_label_new ("Color Scheme");
  cs_fgbglabel = gtk_label_new ("Foreground/Background");

  gtk_box_pack_start (GTK_BOX(area), cs_vbox5, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(cs_vbox5), cs_hbox1, TRUE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX(cs_hbox1), cs_vbox1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(cs_hbox1), cs_vbox2, TRUE, TRUE, 0);
  
  cs_schememenu = gtk_menu_new ();

  menus[0] = gtk_menu_item_new_with_label ("Linux Console");
  gtk_signal_connect (GTK_OBJECT(menus[0]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)1);

  gtk_menu_append (GTK_MENU(cs_schememenu), menus[0]);  
  

  menus[1] = gtk_menu_item_new_with_label ("XTerm");
  gtk_signal_connect (GTK_OBJECT(menus[1]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)2);

  gtk_menu_append (GTK_MENU(cs_schememenu), menus[1]);  


  menus[2] = gtk_menu_item_new_with_label ("RXVT");
  gtk_signal_connect (GTK_OBJECT(menus[2]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)3);

  gtk_menu_append (GTK_MENU(cs_schememenu), menus[2]);  

  menus[3] = gtk_menu_item_new_with_label ("Custom");
  gtk_signal_connect (GTK_OBJECT(menus[3]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)4);

  gtk_menu_append (GTK_MENU(cs_schememenu), menus[3]);  
 

  cs_fgbgmenu = gtk_menu_new ();

  menus[4] = gtk_menu_item_new_with_label ("White on Black");
  gtk_signal_connect (GTK_OBJECT(menus[4]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)101);

  gtk_menu_append (GTK_MENU(cs_fgbgmenu), menus[4]);  

  menus[5] = gtk_menu_item_new_with_label ("Black on White");
  gtk_signal_connect (GTK_OBJECT(menus[5]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)102);

  gtk_menu_append (GTK_MENU(cs_fgbgmenu), menus[5]);  


  menus[6] = gtk_menu_item_new_with_label ("Green on Black");
  gtk_signal_connect (GTK_OBJECT(menus[6]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)103);

  gtk_menu_append (GTK_MENU(cs_fgbgmenu), menus[6]);  

  menus[7] = gtk_menu_item_new_with_label ("Custom");
  gtk_signal_connect (GTK_OBJECT(menus[7]), "activate",
			     GTK_SIGNAL_FUNC (color_menu_event), (gpointer)104);

  gtk_menu_append (GTK_MENU(cs_fgbgmenu), menus[7]);  



  cs_dropscheme = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU(cs_dropscheme), GTK_WIDGET(cs_schememenu));

  cs_dropfgbg = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU(cs_dropfgbg), GTK_WIDGET (cs_fgbgmenu));

  gtk_box_pack_start (GTK_BOX(cs_vbox1), cs_schemelabel, TRUE, TRUE,0);
  gtk_box_pack_start (GTK_BOX(cs_vbox2), cs_dropscheme, TRUE, TRUE, 0);

  for (a=0;a<8;a++)
    {
      color_pickers[a] = gnome_color_picker_new ();
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a]),
				  ColorPrefs.red[a], ColorPrefs.green[a],
				  ColorPrefs.blue[a], 0);

      gtk_table_attach_defaults (GTK_TABLE(color_table), GTK_WIDGET(color_pickers[a]),
			a, a+1, 0, 1);
 
      color_pickers[a+8] = gnome_color_picker_new ();
      gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[a+8]),
				  ColorPrefs.red[a+8], ColorPrefs.green[a+8],
				  ColorPrefs.blue[a+8], 0);

      gtk_table_attach_defaults (GTK_TABLE(color_table), GTK_WIDGET(color_pickers[a+8]),
			a, a+1, 1, 2);
 
   }

  gtk_box_pack_start (GTK_BOX(cs_vbox5), color_table, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX(cs_vbox5), cs_hbox2, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(cs_hbox2), cs_vbox3, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(cs_hbox2), cs_vbox4, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(cs_vbox3), cs_fgbglabel, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(cs_vbox4), cs_dropfgbg, TRUE, TRUE, 0);

  color_pickers[16] = gnome_color_picker_new();
  
  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[16]),
				  ColorPrefs.fg[0], ColorPrefs.fg[1],
				  ColorPrefs.fg[2], 0);
 
  color_pickers[17] = gnome_color_picker_new();
  
  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(color_pickers[17]),
				  ColorPrefs.bg[0], ColorPrefs.bg[1],
				  ColorPrefs.bg[2], 0);

  cs_fglabel = gtk_label_new ("Foreground Color");
  cs_bglabel = gtk_label_new ("Background Color");

  gtk_table_attach_defaults (GTK_TABLE(color_table2), GTK_WIDGET(cs_fglabel),
			     0, 4, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE(color_table2), GTK_WIDGET(cs_bglabel),
			     0, 4, 1, 2);

  gtk_table_attach_defaults (GTK_TABLE(color_table2), GTK_WIDGET(color_pickers[16]),
			     4, 5, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE(color_table2), GTK_WIDGET(color_pickers[17]),
			     4, 5, 1, 2);

  gtk_box_pack_start (GTK_BOX(cs_vbox5), color_table2, FALSE, FALSE, 0);

  for (a=0;a<18;a++)
    gtk_signal_connect (GTK_OBJECT(color_pickers[a]), "color-set", GTK_SIGNAL_FUNC (property_changed), NULL);


  bscheme = ColorPrefs.palette;
  gtk_option_menu_set_history (GTK_OPTION_MENU(cs_dropscheme), bscheme);

  bfgbg = 7;

  if (!ColorPrefs.fg[0] && !ColorPrefs.fg[1] && !ColorPrefs.fg[2])
    if ((ColorPrefs.bg[0] == 0xffff)&&(ColorPrefs.bg[1] == 0xffff)&&(ColorPrefs.bg[2] == 0xffff))
      bfgbg = 5;

  if (!ColorPrefs.bg[0] && !ColorPrefs.bg[1] && !ColorPrefs.bg[2])
    if ((ColorPrefs.fg[0] == 0xffff)&&(ColorPrefs.fg[1] == 0xffff)&&(ColorPrefs.fg[2] == 0xffff))
      bfgbg = 4;

  if (!ColorPrefs.bg[0] && !ColorPrefs.bg[1] && !ColorPrefs.bg[2])
    if ((ColorPrefs.fg[0] == 0)&&(ColorPrefs.fg[1] == 0xffff)&&(ColorPrefs.fg[2] == 0))
      bfgbg = 6;

  gtk_option_menu_set_history (GTK_OPTION_MENU(cs_dropfgbg), bfgbg-4);

  if (bscheme != PALETTE_CUSTOM)
    for (a=0;a<16;a++)
      gtk_widget_set_sensitive (color_pickers[a], FALSE);

  if (bfgbg != 7)
    {
      gtk_widget_set_sensitive (color_pickers[16], FALSE);
      gtk_widget_set_sensitive (color_pickers[17], FALSE);
      
    }

}
