  /*  rcfile.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include "powershell.h"

#define DEFAULT_RCFILE "# PowerShell v0.1\n\
#\n\
# Syntax:\n\
#\n\
# For each application you want to have a menu option, you need the\n\
# following entry:\n\
#\n\
# [app]\n\
# <tab name>\n\
# <command>\n\
# <menu title>\n\
#\n\
# If you want to define a custom menu for the application, you need the\n\
# following (this must come before the next app entry)\n\
#\n\
# [appmenu]\n\
# <menu title>\n\
# <menu item name> <accelerator> <keystroke>\n\
\n\
[app]\n\
tcsh\n\
/bin/tcsh\n\
New _tcsh tab\n\
\n\
[app]\n\
bash\n\
/bin/bash\n\
New _bash tab\n\
\n\
[app]\n\
pico\n\
/usr/bin/pico\n\
Run _pico\n\
\n\
[app]\n\
pine\n\
/usr/bin/pine\n\
Run pi_ne\n\
\n\
[app]\n\
emacs\n\
/usr/bin/emacs -nw\n\
Run _emacs\n\
\n\
[app]\n\
lynx\n\
/usr/bin/lynx\n\
Run _Lynx\n\
\n\
[options]\n\
font -misc-fixed-medium-r-normal--12-200-75-75-c-100-iso8859-1\n\
http_handler /usr/bin/lynx\n\
ftp_handler /usr/bin/ncftp\n\
mail_handler /usr/bin/pine\n\
telnet_handler /usr/bin/telnet\n\
\n\
use_pixmap false\n\
transparent false\n\
shaded false\n\
blink false\n\
bell false\n\
scroll_keystroke true\n\
scroll_output false\n\
del_bs_switch false\n\
ask_ssh_password false\n\
scrollbacklines 100\n\
use_matching true\n\
notebookpos 2\n\
hidemenubar false\n\
hidestatusbar false\n\
hidetabswhensingle false\n\
scrollbarpos 0\n\
run_def_shell 1\n\
\n\
scheme linux\n\
bg 65535 65535 65535\n\
fg 0 0 0\n\
\n\
[colors]\n\
0 0 0\n\
43690 0 0\n\
0 43690 0\n\
43690 21845 0\n\
0 0 43690\n\
43690 0 43690\n\
0 43690 43690\n\
43690 43690 43690\n\
21845 21845 21845\n\
65535 21845 21845\n\
21845 65535 21845\n\
65535 65535 21845\n\
21845 21845 65535\n\
65535 21845 65535\n\
21845 65535 65535\n\
65535 65535 65535\n\
0 0 0\n\
0 0 0\n\
\n\
[eof]\n\
"


int num_apps;

appentry * app_entries;

int InitRCFile ()
{
  FILE * rcfile;
  char * home_dir;
  char tmp[512];
  int a;
  unsigned char c;
  char buf[256];
  int tmp_num;
  guint color;
  int pos;
  
  num_apps = 0;

  bzero (&Prefs, sizeof (Prefs));

  home_dir = getenv ("HOME");
  sprintf (tmp, "%s/.pshellrc", home_dir);
  rcfile = fopen (tmp, "r");
  
  if (!rcfile)
    {
      fprintf (stderr, "%s/.pshellrc does not exist; generating from defaults...\n", home_dir);
      rcfile = fopen (tmp, "w");
      if (!rcfile)
	{
	  fprintf (stderr, "Error opening %s/.pshellrc for writing\n", home_dir);
	  return -1;
	}
      fprintf (rcfile, DEFAULT_RCFILE);
      fclose (rcfile);
      rcfile = fopen (tmp, "r");
      if (!rcfile)
	{
	  fprintf (stderr, "Error opening %s/.pshellrc for reading\n", home_dir);
	  return -1;
	}
    }

  pos = -1;
  num_apps = 0;
  app_entries = (appentry *)malloc (sizeof(appentry));
  while (!feof (rcfile))
    {
      if (!strcmp (tmp, "[app]"))
	{
	  num_apps ++;
	  app_entries  = (appentry *)realloc (app_entries, sizeof(appentry) * num_apps);
	}

      a = 0;

      bzero (tmp, 511);

      while (((c = fgetc (rcfile))!='\n') && !feof(rcfile))
	{
	  tmp[a++] = c;
	}

      tmp[a] = '\0';

      if (tmp[0] != '#')
	{
	  if (!strcmp (tmp, "[app]"))
	  {
	    pos = 0;
	  }

	  if (strlen (tmp))
	    switch (pos)
	      {
	      case 0:
		pos++;
		break;
	      case 1:
		app_entries[num_apps-1].tab_title = (char *)malloc (strlen(tmp)+1);
		strcpy (app_entries[num_apps-1].tab_title, tmp);
		pos++;
		break;
	      case 2:
		app_entries[num_apps-1].command = (char *)malloc (strlen(tmp)+1);
		strcpy (app_entries[num_apps-1].command, tmp);
		pos++;
		break;
	      case 3:
		app_entries[num_apps-1].menu_item_title = 
		  (char *)malloc (strlen(tmp)+1);
		strcpy (app_entries[num_apps-1].menu_item_title, tmp);
		pos++;
		break;		
	      case 4:
		if (!strcmp (tmp, "RunOnStartup"))
		  app_entries[num_apps-1].run_on_startup = 1;
		break;
	      }

	  if (strstr (tmp, "http_handler"))
	    strcpy (Prefs.http_handler, tmp + 13);
	  if (strstr (tmp, "ftp_handler"))
	    strcpy (Prefs.ftp_handler, tmp + 12);
	  if (strstr (tmp, "mail_handler"))
	    strcpy (Prefs.mail_handler, tmp + 13);
	  if (strstr (tmp, "telnet_handler"))
	    strcpy (Prefs.telnet_handler, tmp + 15);
	  if (strstr (tmp, "bg_pixmap"))
	    strcpy (Prefs.bg_pixmap, tmp + 10); 
	  if (strstr (tmp, "font"))
	    strcpy (Prefs.font, tmp+5);
	  if (strstr (tmp, "scheme"))
	    {
	      strcpy (buf, tmp+7);

	      ColorPrefs.palette = PALETTE_CUSTOM;

	      if (strstr (buf, "linux"))
		ColorPrefs.palette = PALETTE_LINUX;
	      
	      if (strstr (buf, "xterm"))
		ColorPrefs.palette = PALETTE_XTERM;
	      
	      if (strstr (buf, "rxvt"))
		ColorPrefs.palette = PALETTE_RXVT;

	    }

	  if (strstr (tmp, "fg ") == tmp)
	    {
	      sscanf (tmp+3, "%hd %hd %hd", &ColorPrefs.fg[0], &ColorPrefs.fg[1], &ColorPrefs.fg[2]);
	    }
	  if (strstr (tmp, "bg ") == tmp)
	    {
	      sscanf (tmp+3, "%hd %hd %hd", &ColorPrefs.bg[0], &ColorPrefs.bg[1], &ColorPrefs.bg[2]);
	    }

	  if (strstr (tmp, "use_pixmap"))
	    {
	      strcpy (buf, tmp + 11);
	      if (!strcmp (buf, "true"))
		Prefs.use_pixmap = 1;
	      else
		Prefs.use_pixmap = 0;
	    }

	  if (strstr (tmp, "run_def_shell"))
	    {
	      strcpy (buf, tmp + 14);
	      if (!strcmp (buf, "true"))
		Prefs.run_def_shell = 1;
	      else
		Prefs.run_def_shell = 0;

	    }

	  if (strstr (tmp, "use_matching"))
	    {
	      strcpy (buf, tmp + 13);
	      if (!strcmp (buf, "true"))
		Prefs.use_matching = 1;
	      else
		Prefs.use_matching = 0;
	    }

	  if (strstr (tmp, "transparent"))
	    {
	      strcpy (buf, tmp + 12);
	      if (!strcmp (buf, "true"))
		Prefs.transparent = 1;
	      else
		Prefs.transparent = 0;
	    }

	  if (strstr (tmp, "ask_ssh_password"))
	    {
	      strcpy (buf, tmp + 17);
	      if (!strcmp (buf, "true"))
		Prefs.ask_ssh_password = 1;
	      else
		Prefs.ask_ssh_password = 0;
	    }

	  if (strstr (tmp, "hidemenubar"))
	    {
	      strcpy (buf, tmp + 12);
	      if (!strcmp (buf, "true"))
		Prefs.hidemenubar = 1;
	      else
		Prefs.hidemenubar = 0;
	    }
	  if (strstr (tmp, "hidestatusbar"))
	    {
	      strcpy (buf, tmp + 14);
	      if (!strcmp (buf, "true"))
		Prefs.hidestatusbar = 1;
	      else
		Prefs.hidestatusbar = 0;
	      
	    }
	  if (strstr (tmp, "hidetabswhensingle"))
	    {
	      strcpy (buf, tmp + 19);
	      if (!strcmp (buf, "true"))
		Prefs.hidetabswhensingle = 1;
	      else
		Prefs.hidetabswhensingle = 0;
	      
	    }

	  if (strstr (tmp, "shaded"))
	    {
	      strcpy (buf, tmp + 7);
	      if (!strcmp (buf, "true"))
		Prefs.shaded = 1;
	      else
		Prefs.shaded = 0;
	    }

	  if (strstr (tmp, "blink"))
	    {
	      strcpy (buf, tmp + 6);
	      if (!strcmp (buf, "true"))
		ColorPrefs.blink = 1;
	      else
		ColorPrefs.blink = 0;
	    }

	  if (strstr (tmp, "bell"))
	    {
	      strcpy (buf, tmp + 5);
	      if (!strcmp (buf, "true"))
		ColorPrefs.bell = 1;
	      else
		ColorPrefs.bell = 0;
	    }
	  if (strstr (tmp, "scroll_keystroke"))
	    {
	      strcpy (buf, tmp + 17);
	      if (!strcmp (buf, "true"))
		ColorPrefs.scroll_keystroke = 1;
	      else
		ColorPrefs.scroll_keystroke = 0;
	    }
	  if (strstr (tmp, "scroll_output"))
	    {
	      strcpy (buf, tmp + 14);
	      if (!strcmp (buf, "true"))
		ColorPrefs.scroll_output = 1;
	      else
		ColorPrefs.scroll_output = 0;
	    }
	  if (strstr (tmp, "del_bs_switch"))
	    {
	      strcpy (buf, tmp + 14);
	      if (!strcmp (buf, "true"))
		ColorPrefs.del_bs_switch = 1;
	      else
		ColorPrefs.del_bs_switch = 0;
	    }

	  if (strstr (tmp, "scrollbacklines"))
	    {
	      strcpy (buf, tmp + 16);
	      
	      tmp_num = atoi (buf);
	      Prefs.scrollbacklines = tmp_num;
	    }

	  if (strstr (tmp, "notebookpos"))
	    {
	      strcpy (buf, tmp+12);
	      tmp_num = atoi (buf);

	      Prefs.notebookpos = ((tmp_num>=0)&&(tmp_num<5)) ? tmp_num : 2;
	    }

	  if (strstr (tmp, "scrollbarpos"))
	    {
	      strcpy (buf, tmp+13);
	      tmp_num = atoi (buf);
	      Prefs.scrollbarpos = ((tmp_num>=0)&&(tmp_num<3)) ? tmp_num : 2;



	    }
	  
	  if (!strcmp (tmp, "[shortcuts]"))
	    {
	      fscanf (rcfile, "%d %d ", &keyprefs.cycle_forwards.key, &keyprefs.cycle_forwards.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.cycle_backwards.key, &keyprefs.cycle_backwards.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.move_forwards.key, &keyprefs.move_forwards.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.move_backwards.key, &keyprefs.move_backwards.modifiers);

	      fscanf (rcfile, "%d %d ", &keyprefs.close.key, &keyprefs.close.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.quit.key, &keyprefs.quit.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.rename.key, &keyprefs.rename.modifiers);
	      fscanf (rcfile, "%d %d ", &keyprefs.run.key, &keyprefs.run.modifiers);

	      for (a=0;a<20;a++)
		{
		  fscanf (rcfile, "%d %d\n", &keyprefs.specific_term[a].key, &keyprefs.specific_term[a].modifiers);
		}

	    }


	  if (!strcmp (tmp, "[colors]"))
	    {
	      for (a=0;a<18 && !feof(rcfile);a++)
		{
		  fscanf (rcfile, "%d ", &color);
		  ColorPrefs.red[a] = color;

		  fscanf (rcfile, "%d ", &color);
		  ColorPrefs.green[a] = color;

		  fscanf (rcfile, "%d ", &color);
		  ColorPrefs.blue[a] = color;
		}
	      if (!feof(rcfile))
		{
		  ColorPrefs.initialized = 1;
		}
	    }
	}
    }
  if (!ColorPrefs.initialized)
    {

      ColorPrefs.initialized = 1;
      for (a=0;a<18;a++)
	{
	      ColorPrefs.red[a] = linux_red[a];
	      ColorPrefs.green[a] = linux_grn[a];
	      ColorPrefs.blue[a] = linux_blu[a];
	}

      ColorPrefs.palette = PALETTE_LINUX;
      ColorPrefs.fg[0] = ColorPrefs.fg[1] = ColorPrefs.fg[2] = 0x0000;
      ColorPrefs.bg[0] = ColorPrefs.bg[1] = ColorPrefs.bg[2] = 0xffff;
    }
      
  fclose (rcfile);

  return 0;
}

int WriteRCFile()
{
  int a;
  FILE * rcfile;
  char * home_dir;
  char buf[512];

  Prefs.scrollbacklines = scrollbacklines;

  home_dir = getenv ("HOME");
  sprintf (buf, "%s/.pshellrc", home_dir);
  
  rcfile = fopen (buf, "w");
  if (!rcfile)
    {
      fprintf (stderr, "Can't open %s for writing!\n", buf);
      return -1;
    }

  for (a=0;a<num_apps;a++)
    {
      fprintf (rcfile, "[app]\n");
      fprintf (rcfile, "%s\n", app_entries[a].tab_title);
      fprintf (rcfile, "%s\n", app_entries[a].command);
      fprintf (rcfile, "%s\n", app_entries[a].menu_item_title);
      if (app_entries[a].run_on_startup)
	fprintf (rcfile, "RunOnStartup\n");
      fprintf (rcfile, "\n");
    }

  fprintf (rcfile, "[options]\n");
  fprintf (rcfile, "font %s\n", Prefs.font);
  fprintf (rcfile, "http_handler %s\n", Prefs.http_handler);
  fprintf (rcfile, "ftp_handler %s\n", Prefs.ftp_handler);
  fprintf (rcfile, "mail_handler %s\n", Prefs.mail_handler);
  fprintf (rcfile, "telnet_handler %s\n\n", Prefs.telnet_handler);

  fprintf (rcfile, "use_pixmap %s\n", Prefs.use_pixmap ? "true" : "false");
  fprintf (rcfile, "transparent %s\n", Prefs.transparent ? "true" : "false");
  fprintf (rcfile, "shaded %s\n", Prefs.shaded ? "true" : "false");
  if (strlen (Prefs.bg_pixmap))
    fprintf (rcfile, "bg_pixmap %s\n", Prefs.bg_pixmap);
  fprintf (rcfile, "blink %s\n", ColorPrefs.blink ? "true" : "false");
  fprintf (rcfile, "bell %s\n", ColorPrefs.bell ? "true" : "false");
  fprintf (rcfile, "scroll_keystroke %s\n", ColorPrefs.scroll_keystroke ? "true" : "false");
  fprintf (rcfile, "scroll_output %s\n", ColorPrefs.scroll_output ? "true" : "false");
  fprintf (rcfile, "del_bs_switch %s\n", ColorPrefs.del_bs_switch ? "true" : "false");
  fprintf (rcfile, "ask_ssh_password %s\n", Prefs.ask_ssh_password ? "true" : "false");
  fprintf (rcfile, "scrollbacklines %d\n", Prefs.scrollbacklines);
  fprintf (rcfile, "use_matching %s\n", Prefs.use_matching ? "true" : "false");
  fprintf (rcfile, "notebookpos %d\n", Prefs.notebookpos);
  fprintf (rcfile, "hidemenubar %s\n", Prefs.hidemenubar ? "true" : "false");
  fprintf (rcfile, "hidestatusbar %s\n", Prefs.hidestatusbar ? "true" : "false");
  fprintf (rcfile, "hidetabswhensingle %s\n", Prefs.hidetabswhensingle ? "true" : "false");
  fprintf (rcfile, "scrollbarpos %d\n", Prefs.scrollbarpos);
  fprintf (rcfile, "run_def_shell %s\n", Prefs.run_def_shell ? "true" : "false");

  fprintf (rcfile, "\n[shortcuts]\n");
  fprintf (rcfile, "%d %d %d %d %d %d %d %d\n", keyprefs.cycle_forwards.key, keyprefs.cycle_forwards.modifiers,
	   keyprefs.cycle_backwards.key, keyprefs.cycle_backwards.modifiers,
	   keyprefs.move_forwards.key, keyprefs.move_forwards.modifiers,
	   keyprefs.move_backwards.key, keyprefs.move_backwards.modifiers);
  fprintf (rcfile, "%d %d %d %d %d %d %d %d\n", keyprefs.close.key, keyprefs.close.modifiers,
	   keyprefs.quit.key, keyprefs.quit.modifiers,
	   keyprefs.rename.key, keyprefs.rename.modifiers,
	   keyprefs.run.key, keyprefs.run.modifiers);
  for (a=0;a<20;a++)
    fprintf (rcfile, "%d %d\n", keyprefs.specific_term[a].key, keyprefs.specific_term[a].modifiers);
  fprintf (rcfile, "\n");

  switch (ColorPrefs.palette)
    {
    case PALETTE_LINUX:
      strcpy (buf, "linux");
      break;
    case PALETTE_XTERM:
      strcpy (buf, "xterm");
      break;
    case PALETTE_RXVT:
      strcpy (buf, "rxvt");
      break;
    default:
      strcpy (buf, "custom");
      break;
    }
  
  fprintf (rcfile, "scheme %s\n", 
	   buf);
  fprintf (rcfile, "fg %d %d %d\n", ColorPrefs.fg[0], ColorPrefs.fg[1], ColorPrefs.fg[2]);
  fprintf (rcfile, "bg %d %d %d\n", ColorPrefs.bg[0], ColorPrefs.bg[1], ColorPrefs.bg[2]);

  fprintf (rcfile, "\n[colors]\n");
  for (a=0;a<18;a++)
    {
      fprintf (rcfile, "%d %d %d\n", ColorPrefs.red[a], ColorPrefs.green[a], ColorPrefs.blue[a]);
    }
  fprintf (rcfile, "\n\n[eof]");

  fclose (rcfile);

  return 0;
}
