open StdLabels

include Ast_pattern0

let save_context ctx = ctx.matched
let restore_context ctx backup = ctx.matched <- backup

let incr_matched c = c.matched <- c.matched + 1

let parse (T f) loc x k = f { matched = 0 } loc x k

module Packed = struct
  type ('a, 'b) t = T : ('a, 'b, 'c) Ast_pattern0.t * 'b -> ('a, 'c) t

  let create t f = T (t, f)
  let parse (T (t, f)) loc x = parse t loc x f
end

let __ = T (fun ctx _loc x k -> incr_matched ctx; k x)

let __' = T (fun ctx loc x k -> incr_matched ctx; k { Location. loc; txt = x })

let drop = T (fun ctx _loc _ k -> incr_matched ctx; k)

let cst ~to_string ?(equal=(=)) v = T (fun ctx loc x k ->
  if equal x v then begin
    incr_matched ctx;
    k
  end else
    fail loc (to_string v)
);;

let int       v = cst ~to_string:string_of_int         v
let char      v = cst ~to_string:(Printf.sprintf "%C") v
let string    v = cst ~to_string:(Printf.sprintf "%S") v
let float     v = cst ~to_string:string_of_float       v
let int32     v = cst ~to_string:Int32.to_string       v
let int64     v = cst ~to_string:Int64.to_string       v
let nativeint v = cst ~to_string:Nativeint.to_string   v
let bool      v = cst ~to_string:string_of_bool        v

let pair (T f1) (T f2) = T (fun ctx loc (x1, x2) k ->
  let k = f1 ctx loc x1 k in
  let k = f2 ctx loc x2 k in
  k
);;

let ( ** ) = pair

let triple (T f1) (T f2) (T f3) = T (fun ctx loc (x1, x2, x3) k ->
  let k = f1 ctx loc x1 k in
  let k = f2 ctx loc x2 k in
  let k = f3 ctx loc x3 k in
  k
);;

let alt (T f1) (T f2) = T (fun ctx loc x k ->
  let backup = save_context ctx in
  try
    f1 ctx loc x k
  with e1 ->
    let m1 = save_context ctx in
    restore_context ctx backup;
    try
      f2 ctx loc x k
    with e2 ->
      let m2 = save_context ctx in
      if m1 >= m2 then begin
        restore_context ctx m1;
        raise e1
      end else
        raise e2
);;

let ( ||| ) = alt

let map (T func) ~f = T (fun ctx loc x k -> func ctx loc x (f k))
let map' (T func) ~f = T (fun ctx loc x k -> func ctx loc x (f loc k))
let map_result (T func) ~f = T (fun ctx loc x k -> f (func ctx loc x k))

let ( >>| ) t f = map t ~f

let many (T f) = T (fun ctx loc l k ->
  k (List.map l ~f:(fun x -> f ctx loc x (fun x -> x))))
;;

let loc (T f) = T (fun ctx _loc (x : _ Location.loc) k ->
  f ctx x.loc x.txt k)
;;

let pack0 t = map t ~f:(fun f -> f ())
let pack2 t = map t ~f:(fun f x y -> f (x, y))
let pack3 t = map t ~f:(fun f x y z -> f (x, y, z))

include Ast_pattern_generated

let ( ^:: ) = cons

let eint       t = pexp_constant (const_int t)
let echar      t = pexp_constant (const_char t)
let estring    t = pexp_constant (const_string t drop)
let efloat     t = pexp_constant (const_float t)
let eint32     t = pexp_constant (const_int32 t)
let eint64     t = pexp_constant (const_int64 t)
let enativeint t = pexp_constant (const_nativeint t)

let pint       t = ppat_constant (const_int t)
let pchar      t = ppat_constant (const_char t)
let pstring    t = ppat_constant (const_string t drop)
let pfloat     t = ppat_constant (const_float t)
let pint32     t = ppat_constant (const_int32 t)
let pint64     t = ppat_constant (const_int64 t)
let pnativeint t = ppat_constant (const_nativeint t)

let single_expr_payload t = pstr (pstr_eval t nil ^:: nil)

let no_label t = string "" ** t

let attribute (T f1) (T f2) = T (fun ctx loc ((name : _ Location.loc), payload) k ->
  let k = f1 ctx name.loc name.txt k in
  let k = f2 ctx loc payload k in
  k
)

let extension = attribute

let of_func f = (T f)
let to_func (T f) = f
