#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <X11/xpm.h>
#include <stdio.h>
#include "TimeP.h"

#include "pixmap/t0.xpm"
#include "pixmap/t1.xpm"
#include "pixmap/t2.xpm"
#include "pixmap/t3.xpm"
#include "pixmap/t4.xpm"
#include "pixmap/t5.xpm"
#include "pixmap/t6.xpm"
#include "pixmap/t7.xpm"
#include "pixmap/t8.xpm"
#include "pixmap/t9.xpm"
#include "pixmap/tn.xpm"
#include "pixmap/tm.xpm"
#include "pixmap/ca.xpm"
#include "pixmap/cb.xpm"

#define TIME_WIDTH  (47)
#define TIME_HEIGHT (14)
#define BASE_COLOR  "#282828"

#define sDisp      XtDisplay(tw)
#define sScreen    XtScreen(tw)
#define sRoot      XRootWindowOfScreen(XtScreen(tw))
#define sWidth     tw->core.width
#define sHeight    tw->core.height
#define sPixmap    tw->time.pixmap
#define sParts(i)  tw->time.parts_pixmap[i]
#define sAttr(i)   tw->time.parts_attr[i]
#define sGC        tw->time.gc

static char** pixmap_name[] =
{
        t0_xpm, t1_xpm, t2_xpm, t3_xpm, t4_xpm,
        t5_xpm, t6_xpm, t7_xpm, t8_xpm, t9_xpm,
        tn_xpm, tm_xpm, ca_xpm, cb_xpm
};

static int xpos_num[] =
{
        1, 8, 17, 24, 33, 40
};

#define offset(field) XtOffsetOf(TimeRec, field)
static XtResource resources[] = {
  { XtNtime, XtCTime, XtRInt, sizeof(int),
            offset(time.time), XtRImmediate, (XtPointer)-1 },
};
#undef offset

static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static XtGeometryResult QueryGeometry();
static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};
static void ShowTime();

TimeClassRec timeClassRec = {
  {
  /* superclass             */ (WidgetClass) &coreClassRec,
  /* class_name             */ "Time",
  /* widget_size            */ sizeof(TimeRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                */ XtInheritRealize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ Redisplay,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass timeWidgetClass = (WidgetClass)&timeClassRec;

static void
GetGC(TimeWidget tw)
{
        XGCValues values;
        XtGCMask  mask;
        XColor exact;
        Colormap cmap;

        cmap=DefaultColormapOfScreen(sScreen);
        XAllocNamedColor(sDisp, cmap, BASE_COLOR, &(tw->time.color), &exact);
        values.foreground = tw->time.color.pixel;
        values.background = tw->core.background_pixel;
        values.graphics_exposures = False;
        mask = GCForeground | GCBackground | GCGraphicsExposures;
        sGC = XCreateGC(sDisp, sPixmap, mask, &values);
}

static void
GetPixmap(TimeWidget tw)
{
        int i;
        Pixmap Mask;
        int rst;

        for(i=0; i<14; i++) {
                sAttr(i).valuemask = XpmReturnInfos 
                                   | XpmReturnAllocPixels
                                   | XpmReturnExtensions;
                rst = XpmCreatePixmapFromData(sDisp, sRoot, pixmap_name[i],
                                        &sParts(i), &Mask, &sAttr(i));
                if (rst != 0) XpmError(rst);
                if (Mask) XFreePixmap(sDisp, Mask);
        }
}

static void
Initialize(Widget wreq, Widget wnew)
{
        TimeWidget tw = (TimeWidget) wnew;
        Pixmap Mask;

        if (sWidth == 0) {
                sWidth = TIME_WIDTH;
        }
        if (sHeight == 0) {
                sHeight = TIME_HEIGHT;
        }
        sPixmap = XCreatePixmap(sDisp, sRoot, sWidth, sHeight,
                               DefaultDepthOfScreen(sScreen));
        GetGC(tw);
        GetPixmap(tw);
        XFillRectangle(sDisp, sPixmap, sGC,  0, 0, sWidth, sHeight);
        ShowTime(tw);
}

static void
Redisplay(Widget w, XExposeEvent *event)
{
        TimeWidget tw = (TimeWidget) w;
        int x,y;
        int width, height;

        if (XtIsRealized(w)) {
                if (event) {
                        x = event->x;
                        y = event->y;
                        width = event->width;
                        height = event->height;
                } else {
                        x = 0;
                        y = 0;
                        width = sWidth;
                        height = sHeight;
                }
                XCopyArea(sDisp, sPixmap, XtWindow(tw), sGC,
                          x, y, width, height, x, y);
        }
}


static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        TimeWidget cur = (TimeWidget) wcur;
        TimeWidget new = (TimeWidget) wnew;
        Boolean redraw = False;

        if (cur->time.time != new->time.time) {
                ShowTime(new);
        }

        return redraw;
}

static void
Destroy(Widget w)
{
        TimeWidget tw = (TimeWidget) w;
        Colormap cmap;
        int i;

        cmap=DefaultColormapOfScreen(sScreen);
        XFreeColors(sDisp, cmap, &tw->time.color.pixel, 1, 0);
        if (sGC) XFreeGC(sDisp, sGC);
        if (sPixmap)
                XFreePixmap(sDisp, sPixmap);

        for(i=0; i<14; i++) {
                if (sParts(i))
                        XFreePixmap(sDisp, sParts(i));
                XFreeColors(sDisp, cmap,
                            sAttr(i).alloc_pixels,
                            sAttr(i).nalloc_pixels, 0);
                XpmFreeAttributes(&sAttr(i));
        }
}

static void Resize(Widget w)
{
        TimeWidget tw = (TimeWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        TimeWidget tw = (TimeWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;
        return XtGeometryAlmost;
}

static void
ShowTime(TimeWidget tw)
{
        XExposeEvent rrect;
        static int old_num[6] = {-1, -1, -1, -1, -1};
        static int old_colon = -1;
        int num[6];
        int colon;
        int t;
        int redisp;
        int i;

        t = tw->time.time;
        redisp = False;

        if (t < 0) {
                for(i=0; i<6; i++) {
                        num[i]=10;
                }
                colon=0;
        } else if (t >= 86400) {
                for(i=0; i<6; i++) {
                        num[i]=11;
                }
                colon=1;
        } else {
                num[0] = (t /3600) / 10;
                num[1] = (t /3600) % 10;
                num[2] = ((t / 60) % 60) / 10;
                num[3] = ((t / 60) % 60) % 10;
                num[4] = (t % 60) / 10;
                num[5] = (t % 60) % 10;
                colon=1;
        }

        for(i=0; i<6; i++) {
                if (old_num[i] != num[i]) {
                        XCopyArea(sDisp, sParts(num[i]), sPixmap, sGC,
                                  0,0, 7,14, xpos_num[i], 0);
                        old_num[i] = num[i];
                redisp = True;
                }
        }

        if (old_colon != colon) {
                XCopyArea(sDisp, sParts(colon+12), sPixmap, sGC,
                          0,0, 2,14, 15, 0);
                XCopyArea(sDisp, sParts(colon+12), sPixmap, sGC,
                          0,0, 2,14, 31, 0);
                old_colon = colon;
                redisp = True;
        }

        if (redisp) {
                rrect.x = 0;
                rrect.y = 0;
                rrect.width = sWidth;
                rrect.height = sHeight;
                Redisplay((Widget)tw, &rrect);
        }
}
