#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#include "option.h"
#include "log.h"

#include "frame.h"
#include "env.h"
#include "lcp.h"
#include "cps.h"
#include "phase.h"
#include "auth.h"

enum {
    PAP_REQUEST=1,
    PAP_ACK,
    PAP_NAK
};

const char *papName[]={
    "Request",
    "Ack",
    "Nak"
};

static u_int8_t authId;

static bool_t
PapCheck(char *user, char *passwd)
{
    struct passwd_s *pwp;
    char buf[100];

    switch (pppOpt.a_server) {
    case AUTH_SERVER_FILE:
	pwp = GetPasswdByName(user);
	if (!pwp || !pwp->passwd) return(FALSE);
	SetPasswd(pwp->entry, pwp->name, pwp->passwd, pwp->key);
	if (!AuthCmp(passwd)) return(FALSE);
	if (pwp->script) LoadScriptFile(pwp->script);
	break;
    case AUTH_SERVER_RADIUS:
	pwp = GetPasswdByEntry(pppOpt.a_entry);
	if (!pwp || !pwp->passwd) return(FALSE);
	SetPasswd(pwp->entry, pwp->name, pwp->passwd, pwp->key);
	AuthDecode(buf, sizeof(buf));
	RadiusSetSecret(buf);
	if (!RadiusAccessRequest(user, passwd)) return(FALSE);
	SetPasswd(NULL, user, NULL, 0);
	break;
    case AUTH_SERVER_UNIX:
	if (!UnixCheckPasswd(user, passwd)) return(FALSE);
	SetPasswd(NULL, user, NULL, 0);
	break;
    case AUTH_SERVER_NONE:
	break;
    default:
	return(FALSE);
    }
    return(TRUE);
}

static void
PapEnqueue(cpcode_t code)
{
    struct cpframeheader_s pfb;
    int len;
    u_char *p, authbuf[BUFSIZ];
    char *name, key[100];

    memset(authbuf, 0, sizeof(authbuf));
    p = authbuf + sizeof(struct cpframeheader_s);
    pfb.code = code;
    pfb.id = authId;
    if (ISLOG(LOG_AUTHP))
	Logf(LOG_AUTHP, "PAP: Send-%s id=%d\n",
	     papName[code - 1], pfb.id);
    switch (code) {
    case PAP_REQUEST:
	AuthDecode(key, sizeof(key));
	name = AuthName();
	if (ISLOG(LOG_AUTHP)) {
	    Logf(LOG_AUTHP, " Name(%d): %s\n",
		 ISLOG(LOG_PRIVATE) ? strlen(name): -1,
		 ISLOG(LOG_PRIVATE) ? name: "<name>");
	    Logf(LOG_AUTHP, " Passwd(%d): %s\n",
		 ISLOG(LOG_SECRET) ? strlen(key): -1,
		 ISLOG(LOG_SECRET) ? key: "<password>");
	}
	len = strlen(name);
	*p = len;
	memcpy(p + 1, name, len);
	p += len + 1;
	len = strlen(key);
	*p = len;
	memcpy(p + 1, key, len);
	p += len + 1;
	break;
    }
    pfb.nbo_len = htons(p - authbuf);
    memcpy(authbuf, &pfb, sizeof(pfb));
    FrameEnqueue(authbuf, p - authbuf, NBO_PROTO_PAP, PRI_AUTH);
}

time_t
PapDecodeFrame(u_char *buf, int len, long arg)
{
    struct cpframeheader_s *pfp;
    char name[MAX_PWSLEN], passwd[MAX_PWSLEN];
    int n;

    pfp = (struct cpframeheader_s *)buf;
    buf += sizeof(struct cpframeheader_s);
    len -= sizeof(struct cpframeheader_s);
    if (ISLOG(LOG_AUTHP))
	Logf(LOG_AUTHP, "PAP: Received-%s id=%d\n",
	     papName[pfp->code - 1], pfp->id);
    switch (pfp->code) {
    case PAP_REQUEST:
	memset(name, 0, MAX_PWSLEN);
	memset(passwd, 0, MAX_PWSLEN);
	n = *buf ++;
	strncpy(name, buf, (n > MAX_PWSLEN - 1) ? MAX_PWSLEN - 1: n);
	buf += n;
	n = *buf ++;
	strncpy(passwd, buf, (n > MAX_PWSLEN - 1) ? MAX_PWSLEN - 1: n);
	if (ISLOG(LOG_AUTHP)) {
	    Logf(LOG_AUTHP, " Name(%d): %s\n",
		 ISLOG(LOG_PRIVATE) ? strlen(name): -1,
		 ISLOG(LOG_PRIVATE) ? name: "<name>");
	    Logf(LOG_AUTHP, " Passwd(%d): %s\n",
		 ISLOG(LOG_SECRET) ? strlen(passwd): -1,
		 ISLOG(LOG_SECRET) ? passwd: "<password>");
	}
	if (PapCheck(name, passwd)) {
	    phaseShift = PHASE_UP;
	    PapEnqueue(PAP_ACK);
	    break;
	}
	PapEnqueue(PAP_NAK);
	phaseShift = PHASE_DOWN;
	break;
    case PAP_NAK:
	if (len && *buf) {
	    len --;
	    if (ISLOG(LOG_AUTHP)) {
		Logf(LOG_AUTHP, " \"%.*s\"\n", (len < *buf) ? len: *buf,
		     buf + 1);
	    }
	}
	PhaseDown();	/* down soon!! */
	break;
    case PAP_ACK:
	if (len && *buf) {
	    len --;
	    if (ISLOG(LOG_AUTHP)) {
		Logf(LOG_AUTHP, " \"%.*s\"\n", (len < *buf) ? len: *buf,
		     buf + 1);
	    }
	}
	PhaseUp();
	break;
    }
    SetAuthTimer(NULL, NULL);
    return(0);
}

void
PapStart()
{
    int id;

    if ((id = SetAuthTimer("PAP", PapStart)) > 0) {
	authId = id;
	PapEnqueue(PAP_REQUEST);
    }
}
