/* $Cambridge: hermes/src/prayer/session/role.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Data structures for user roles */

#define ROLE_POOL_SIZE (1024)

struct role {
    struct role *next;          /* Linked list */
    char *name;                 /* Alias */
    char *personal;             /* Personal Name */
    char *from;                 /* From address  */
    char *reply_to;             /* Default Reply to address */
    char *fcc;                  /* Fcc address */
    char *signature;            /* Default signature */
};

void role_parse_line(struct list *rl, char *line, struct session *session);

void role_print_options(struct list *rl, struct buffer *b);

void
role_update(struct list *rl,
            char *name,
            char *personal,
            char *from, char *reply_to, char *fcc, char *signature);
void role_delete(struct list *rl, char *name);

struct role *role_find(struct list *rl, char *name);
