/* $Cambridge: hermes/src/prayer/session/speller.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

struct speller_ignore_list {    /* Temporary Ignore list */
    struct speller_ignore_list *next;   /* Linked list */
    char *word;                 /* Word */
};

struct speller {
    struct pool *pool;          /* Allocation Pool */
    struct iostream *stream;    /* Connection to ispell */
    struct speller_ignore_list *ignore; /* List of errors to ignore */
    char *language;             /* Current ispeller language */
    pid_t pid;                  /* PID of ispell child process */
    char *line;                 /* Current input line */
    unsigned long offset;       /* Offset into input line */
    unsigned long cursize;      /* Size of current word */
    struct buffer *output;      /* Output buffer */
    unsigned long last_line;    /* Output Offset to last line */
    unsigned long last_line1;   /* Output Offset to last-1 line */
    struct buffer *from_speller;        /* Output from ispell */
    unsigned long no_changes;   /* Running count of changes */
};

struct speller *speller_create(struct pool *p);
void speller_free(struct speller *speller);
BOOL
speller_start(struct speller *speller, struct session *session,
              char *text, char *language, BOOL spell_skip_quoted);
void speller_stop(struct speller *speller);
BOOL speller_active(struct speller *speller);
void speller_feedline(struct speller *speller);
char *speller_getline(struct speller *speller, struct pool *pool);
BOOL speller_copy_from_offset(struct speller *speller);
void speller_copy_to_offset(struct speller *speller, unsigned long offset);
void speller_copy_remainder(struct speller *speller);
void speller_copy_string(struct speller *speller, char *s);
char *speller_output(struct speller *speller);
void speller_print_lastline(struct speller *speller, struct buffer *b);

void speller_record_cursize(struct speller *speller, unsigned long size);
unsigned long speller_fetch_cursize(struct speller *speller);
void speller_skip_input(struct speller *speller, unsigned long size);

void speller_add_ignore_list(struct speller *speller, char *word);
BOOL speller_check_ignore_list(struct speller *speller, char *word);
