%{

#include <string.h>
#include <libprelude/variable.h>

#include "rules-parsing.h"
#include "rules-grammar.h"

#define YY_NO_UNPUT
#define MAX_VAR_DEPTH 10
static YY_BUFFER_STATE in_buffer[MAX_VAR_DEPTH];
static int in_buffer_depth;

extern int parse_error_locked;
void remove_bslash(char *dst, const char *src, const uint32_t maxlen);

%}

/* Key Identifier */
ID		[^ \t!,();:$\[\]]+

/* Word */
WORD		((\\[();])|[^ \t!,();$\[\]])+


/* Word for header, (word without < or > ) */
HWORD		[^ \t!\>\<,();$\[\]]+

/* Space */
SPACE		[ \t]+

/* Expression */
EXPRESSION	{WORD}({SPACE}+{WORD})*

/* State VAR : Expand variable value */
%x var

/* State Options, accept first an ID before every word */
%x options

/* State Opt_word, can accept every word */
%s opt_word

%option stack

%%



<*>{SPACE}	;

<*>"$"		{ yy_push_state( var ); }
<var>{WORD}	{
			yy_pop_state();
			if (in_buffer_depth> MAX_VAR_DEPTH) {
			   signature_parser_set_error( "Stack overflow in expanded variable" );
			   yyterminate();
			 } else {
			   
			   char *name = variable_get( (char*) yytext );
			   if (!name) {
			      signature_parser_set_error( "Unknown variable '%s'", yytext );
			      yyterminate();
			    }
			    in_buffer[ ++in_buffer_depth ] = yy_scan_string( name );
			 }
		}
<var>.		{
			yy_pop_state();
			signature_parser_set_error( "Invalid variable name '%s'", yytext );
			yyterminate();
		}
<*><<EOF>>	{
			yy_delete_buffer( in_buffer[ in_buffer_depth-- ] );
			if (in_buffer_depth>=0)
			   yy_switch_to_buffer( in_buffer[ in_buffer_depth ] );
			else
			  yyterminate();
		} 


"("		{ BEGIN( options ); return yytext[0]; }
<options>":"	{ BEGIN( opt_word ); return yytext[0]; }
<opt_word>";"	{ BEGIN( options ) ; return yytext[0]; }

\"([^\\\"]|\\.)*\"	{
				char *tmp = (char*) malloc( yyleng-1 );
				strncpy( tmp, yytext+1, yyleng-2 );
				tmp[ yyleng-2 ] = '\0';
				snortrules_lval.parameters = signature_parser_make_parameters( tmp );
				return STR;
			}

"->"		return TO_DIR;
"<-"		return FROM_DIR;
"<>"		return BI_DIR;

<options>{ID}		|
{HWORD}			{	
				snortrules_lval.parameters = signature_parser_make_parameters( strdup( (char*) yytext) );
				return STR;
			}

<opt_word>{EXPRESSION}	{
				char *tmp = (char*) malloc (yyleng+1);
				remove_bslash( tmp, yytext, yyleng );
				tmp[ yyleng ] = '\0';
				snortrules_lval.parameters = signature_parser_make_parameters( tmp );
				return STR;
			}

<*>.		return yytext[0];

%%

/*
 * Initialize the scanner
 */
void set_parsing_buffer(const char *buf)
{
	in_buffer_depth = 0;
	in_buffer[ in_buffer_depth ] = yy_scan_string( buf );
	parse_error_locked = 0;
	BEGIN(0);
}
 
int
yywrap()
{
        return 1;
}

void remove_bslash(char *dst, const char *src, const uint32_t maxlen)
{
	uint32_t len;
	char c;

	len = 0;
	while(  len <= maxlen )
	{
		c = *src++;
		if( c == '\\')
			c = *src++;
		*dst = c;
		dst++; len++;
		if( c == '\0')
			break;

	}
}
