/*****
*
* Copyright (C) 2001, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Yoann Vandoorselaere <yoann@prelude-ids.org>
*
*****/

#define RPC_HDR_SIZE 24

/*
 * RPC header,
 * To be used by Detection plugins that plug to the RPC protocol plugins.
 */ 
typedef struct {
	uint32_t xid;           /* Transaction identifier       */
	uint32_t call;          /* Type of call (call / answer) */

        
	uint32_t rpc_version;   /* RPC version number          */
	uint32_t program;       /* Program number              */
	uint32_t version;       /* Version number              */
	uint32_t procedure;     /* Procedure number            */
} rpc_hdr_t;

