/*****
*
* Copyright (C) 1998 - 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


/*
 * This file is to be included by Detect Plugins.
 */

#include <stdarg.h>


/*
 * Definition of the packet structure,
 * which is passed to detection plugins.
 */
#include "packet.h"


/*
 * Definition of the log macro, for errors / infos reporting.
 */
#include <libprelude/prelude-log.h>

/*
 * Definition of the common and detect plugin type.
 */
#include <libprelude/plugin-common.h>
#include "plugin-protocol.h"

/*
 * extraction function, handling alignment issue
 */
#include <libprelude/extract.h>

/*
 * Definition of some operation on packet
 */
#include "packet-decode.h"


/*
 * Definition of plugin configuration API.
 */
#include <libprelude/config-engine.h>



/*
 * Signature engine API to add parsing key
 */
#include "rules-parsing.h"


/*
 * Operations on rules.
 */
#include "rules-operations.h"



/*
 * Default contents functions.
 */
#include "rules-default.h"


#include "nids-alert.h"

#include <libprelude/prelude-getopt.h>
