/*****
*
* Copyright (C) 2001, 2002, 2003 Jeremie Brebec <flagg@ifrance.com>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Jeremie Brebec <flagg@ifrance.com>
*
*****/


#ifndef RULES_DEFAULT_H
#define RULES_DEFAULT_H

#include "rules.h"
#include "rules-type.h"
#include "rules-parsing.h"


/*
 * Data type
 */
#define RULE_CONTENT      0
#define RULE_IPOPTS       1



void signature_engine_init(void);

rules_node_t *signature_engine_get_ip_root(void);

rules_node_t *signature_engine_get_tcp_root(void);

rules_node_t *signature_engine_get_udp_root(void);

rules_node_t *signature_engine_get_icmp_root(void);

void signature_engine_start_new_match(void);

/*
 * Generic parsing functions.
 */
int signature_parse_sameip(parameters_t *parameters, rules_t **rules);
int signature_parse_nocase(parameters_t *parameters, rules_t **rules);
int signature_parse_offset(char *str, rules_t **rules);
int signature_parse_depth(char *str, rules_t **rules);
rule_t *signature_get_content_rule(char *str, rules_t **rules);
int signature_parse_content(char *str, rules_t **rules);
int signature_parse_within(char *str, rules_t **rules);
int signature_parse_distance(char *str, rules_t **rules);
int signature_parse_content_list(char *filename, rules_t **rules);
int signature_parse_ttl(char *str, rules_t **rules);
int signature_parse_tos(char *str, rules_t **rules);
int signature_parse_id(char *str, rules_t **rules);
int signature_parse_dsize(char *str, rules_t **rules);
int signature_parse_win(char *str, rules_t **rules);
int signature_parse_seq(char *str, rules_t **rules);
int signature_parse_ack(char *str, rules_t **rules);
int signature_parse_itype(char *str, rules_t **rules);
int signature_parse_icode(char *str, rules_t **rules);
int signature_parse_icmp_id(char *str, rules_t **rules);
int signature_parse_icmp_seq(char *str, rules_t **rules);
int signature_parse_ipproto(char *str, rules_t **rules);

int signature_parse_tcp_flags(char *str, rules_t **rules);
int signature_parse_nothing(parameters_t *parameters, rules_t **rules);


/*
 * Generic matching function.
 */

int signature_match_packet_content(packet_container_t *pc, void *pattern);
int signature_match_content(unsigned char *data, unsigned int dlen, void *pattern);
int signature_match_ipsrc(packet_container_t *pc, ip_t *test);
int signature_match_ipdst(packet_container_t *pc, ip_t *test);
int signature_match_sameip(packet_container_t *pc, void *data);
int signature_match_ipproto(packet_container_t *pc, integer_t *integer);
int signature_match_portsrc(packet_container_t *pc, segment_t *port);
int signature_match_portdst(packet_container_t *pc, segment_t *port);
int signature_match_tcpflags(packet_container_t *pc, flags_t *flags);
int signature_match_fragbits(packet_container_t *pc, flags_t *fragbits);
int signature_match_fragoffset(packet_container_t *pc, integer_t *integer);
int signature_match_ttl(packet_container_t *pc, integer_t *ttl);
int signature_match_tos(packet_container_t *pc, integer_t *tos);
int signature_match_id(packet_container_t *pc, integer_t *id);
int signature_match_datasize(packet_container_t *pc, segment_t *dsize);
int signature_match_win(packet_container_t *pc, integer_t *win);
int signature_match_seq(packet_container_t *pc, integer_t *seq);
int signature_match_ack(packet_container_t *pc, integer_t *ack);
int signature_match_icmptype(packet_container_t *pc, integer_t *itype);
int signature_match_icmpcode(packet_container_t *pc, integer_t *icode);
int signature_match_icmpid(packet_container_t *pc, integer_t *test);
int signature_match_icmpseq(packet_container_t *pc, integer_t *test);
int signature_match_ipopts(packet_container_t *pc, void *ipopts);


uint16_t signature_engine_get_last_matched_offset(void);

void signature_engine_set_last_matched_offset(uint16_t off);


#endif
