/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2002      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: anode.cc,v $
 * Revision 1.4  2003/03/06 14:54:16  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.3  2002/05/02 09:32:32  slash
 * Changes to make PresTiMeL compilable with g++ 3.0.
 * (Thanks to Benjamin Drieu)
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:21  slash
 * Initial release.
 *
 */

#include "main.h"
#include "anode.h"


//---------------------------------------------------------------------------
ANode::ANode(xmlNodePtr node) : InlineNode()
{
    // Extract the properties of the A-tag.
    href_ = (char*)xmlGetProp(node, (xmlChar*)"href");

    html_open_   = std::string("<A href=\"") + href_ + "\">";
    html_close_  = "</A>";
    latex_open_  = "";
    latex_close_ = std::string("(\\url{") + href_ + "})";
    xml_open_    = std::string("<a href=\"") + href_ + "\">";
    xml_close_   = "</a>";

    // Extract the child-nodes.
    read(node);
}

//---------------------------------------------------------------------------
ANode::~ANode()
{
}
