/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: imagenode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:47  slash
 * Initial release.
 *
 */

#ifndef IMAGENODE_H
#define IMAGENODE_H

#include "environmentnode.h"

//---------------------------------------------------------------------------
/**
 * This class represents an image-node.
 */
class ImageNode : public EnvironmentNode {
  public:
    //-----------------------------------------------------------------------
    /**
     * This enumeration defines the possible values for the alignment of
     * the images.
     */
    enum Align {
        UNDEFINED, LEFT, CENTER, RIGHT
    };

    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the image-node.
     *
     * @param node The XML-node, which represents the image-node.
     */
    ImageNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~ImageNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     *
     * @param which_image Indicates, which image should be written.
     */
    void writeHTML(int which_image) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;

    //-----------------------------------------------------------------------
    /**
     * This method signals, if the HTML-output of the image-environment
     * should be stepped.
     *
     * @return 1, if the HTML-output should be stepped, else 0.
     *
     * @see getNumberOfHTMLSteps
     */
    int isHTMLStepped() const;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of steps of the HTML-output.
     *
     * @return The number of steps.
     */
    unsigned int getNumberOfHTMLSteps() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The alignment of the images.
     */
    Align align_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the image in the LaTeX-output should be automatically scaled
     * to the proper size, else 0.
     * If -1, the latex_scale-property was not given in the image-markup.
     */
    int latex_scale_;
};

#endif //IMAGENODE_H
