//
//  MyDocument.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2002-2003-2004 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "MyDocument.h"

#import <limits.h>

@implementation MyDocument

// eliminated windowNibName since we use makeWindowControllers


- (void)windowControllerDidLoadNib:(NSWindowController *) aController
{
    [super windowControllerDidLoadNib:aController];
    // Add any code here that need to be executed once the windowController has loaded the document's window.
}

- (NSData *)dataRepresentationOfType:(NSString *)aType
{
    // Insert code here to write your document from the given data.  You can also choose to override -fileWrapperRepresentationOfType: or -writeToFile:ofType: instead.
//    return nil;
    return [activeImage TIFFRepresentation];
}

- (BOOL)loadDataRepresentation:(NSData *)data ofType:(NSString *)aType
{
    // Insert code here to read your document from the given data.  You can also choose to override -loadFileWrapperRepresentation:ofType: or -readFromFile:ofType: instead.
    activeImage = [[NSImage alloc] initWithData:data];
    if (activeImage)
    {
        NSBitmapImageRep *actImageRep;
        NSImage *newImage;
        NSBitmapImageRep *newImageRep;
        unsigned char *dataPtr;
        unsigned char *dataPtr2;
        unsigned int k;
        unsigned int w, h, s;

        /* if the loaded image is in BlackColorSpace we convert it to WhiteColorSpace */
        /* which is the only TIFF rep used internally and generated by PRICE */
        actImageRep = [[activeImage representations] objectAtIndex: 0];
        if ([[actImageRep colorSpaceName] isEqualToString: NSCalibratedBlackColorSpace] || [[actImageRep colorSpaceName] isEqualToString: NSDeviceBlackColorSpace])
        {
            /* converting the colorspace */
            w = [actImageRep pixelsWide];
            h = [actImageRep pixelsHigh];
            newImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
            newImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
            s = w * h;
            dataPtr = [actImageRep bitmapData];
            dataPtr2 = [newImageRep bitmapData];
            for (k = 0; k < s; k++)
                *dataPtr2++ = UCHAR_MAX - *dataPtr++;
            [newImageRep setColorSpaceName:NSCalibratedWhiteColorSpace];
            [newImage addRepresentation:newImageRep];
            [newImageRep release];
            [self setActiveImage: newImage];
        }
    }
    return (activeImage != nil); /* returns nil to be able to know if loading was successul */
}


- (IBAction)saveDocumentAs:(id)sender
/* we override the super class to change the extensionand type of the file */
{
    NSString *filepath;
    
    filepath = [self fileName];
    filepath = [[filepath stringByDeletingPathExtension] stringByAppendingString: @".tiff"];
    [self setFileName:filepath];
    [self setFileType: @"tiff"];
    [super saveDocumentAs: sender];
}

- (void)makeWindowControllers
/* instantiate PRWindowController */
{
    windowController = [[PRWindowController alloc] initWithWindowNibName:@"PRWindow"];
    [self addWindowController:windowController];
    [windowController release];
}

- (NSImage *)activeImage
/* method to access the active image */
{
    return activeImage;
}

- (void)setActiveImage: (NSImage *)theImage
/* method to set the active image */
{
    [activeImage autorelease];
    activeImage = [theImage retain];
}

- (void)makeGrayscale:(id)sender
{
    PRGrayscaleFilter *filter;
    filter = [[PRGrayscaleFilter alloc] init];
    [self setActiveImage: [filter filterImage:activeImage]];
    [windowController setImageToDraw:activeImage];
    [filter release];
}

- (void)makeConvolve55:(int[5][5])mat: (int)offset :(float)scale :(BOOL)autoScale
{
    PRConvolve55 *conv;
    
    conv = [[PRConvolve55 alloc] init];    
    [self setActiveImage: [conv convolveImage:activeImage :mat :offset :scale :autoScale]];
    [windowController setImageToDraw:activeImage];
    [conv release];
}

- (void)makeDFT:(id)sender
{
    PRFourier *fourier;
    
    fourier = [[PRFourier alloc] init];
    
    [self setActiveImage: [fourier transformImage:activeImage]];
    [windowController setImageToDraw:activeImage];
    [fourier release];
}

- (void)makeDFTLowPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq
{
    PRDFTLowPass *dftLP;
    
    dftLP = [[PRDFTLowPass alloc] init];
    
    [self setActiveImage: [dftLP transformImage:activeImage :autoRange :bandPassFreq :bandStopFreq]];
    [windowController setImageToDraw:activeImage];
    [dftLP release];
}

- (void)makeDFTHighPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq
{
    PRDFTHighPass *dftHP;
    
    dftHP = [[PRDFTHighPass alloc] init];
    
    [self setActiveImage: [dftHP transformImage:activeImage :autoRange :bandPassFreq :bandStopFreq]];
    [windowController setImageToDraw:activeImage];
    [dftHP release];
}

- (void)makeTransposed:(id)sender
{
    PRTransforms *tr;
    
    tr = [[PRTransforms alloc] init];
    [self setActiveImage: [tr transposeImage:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
//    [[windowController view] setNeedsDisplay:YES];
}

- (void)makeRotated90 :(id)sender
{
    PRTransforms *tr;
    
    tr = [[PRTransforms alloc] init];
    [self setActiveImage: [tr rotateImage90:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeRotated180 :(id)sender
{
    PRTransforms *tr;
    
    tr= [[PRTransforms alloc] init];
    [self setActiveImage: [tr rotateImage180:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeRotated270 :(id)sender
{
    PRTransforms *tr;
    
    tr = [[PRTransforms alloc] init];
    [self setActiveImage: [tr rotateImage270:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeFlippedVert :(id)sender
{
    PRTransforms *tr;
    
    tr = [[PRTransforms alloc] init];
    [self setActiveImage: [tr flipImageVert:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeFlippedHoriz :(id)sender
{
    PRTransforms *tr;
    
    tr = [[PRTransforms alloc] init];
    [self setActiveImage: [tr flipImageHoriz:activeImage]];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeEqualization :(id)sender
{
    PREqualize *equal;
    
    equal = [[PREqualize alloc] init];
    [self setActiveImage: [equal equalizeImage:activeImage]];
    [windowController setImageToDraw:activeImage];
    [equal release];
}

- (void)makeTraceEdges :(int)filterType :(BOOL)useTh :(float)thLev :(BOOL)doZeroC
{
    PRTraceEdges *traceEdges;
    
    traceEdges = [[PRTraceEdges alloc] init];
    [self setActiveImage: [traceEdges edgeImage :activeImage :filterType :useTh :thLev :doZeroC]];
    [windowController setImageToDraw:activeImage];
    [traceEdges release];
}

- (void)makeCustTraceEdges :(int)filterType :(float)thLev :(BOOL)doZeroC :(BOOL)do1 :(enum medianForms)form1 :(int)size1 :(BOOL)sep1 :(BOOL)do2 :(enum medianForms)form2 :(int)size2 :(BOOL)sep2 :(BOOL)do3 :(enum medianForms)form3 :(int)size3 :(BOOL)sep3
{
    PRCustTraceEdges *traceEdges;
    
    traceEdges = [[PRCustTraceEdges alloc] init];
    [self setActiveImage: [traceEdges edgeImage :activeImage :filterType :thLev :doZeroC :do1 :form1 :size1 :sep1 :do2 :form2 :size2 :sep2 :do3 :form3 :size3 :sep3]];
    [windowController setImageToDraw:activeImage];
    [traceEdges release];
}

-(void)makeMedian :(enum medianForms)form :(int)size :(BOOL)sep
{
    PRMedian *median;
    
    median = [[PRMedian alloc] init];
    [self setActiveImage: [median medianImage :activeImage :form :size :sep]];
    [windowController setImageToDraw:activeImage];
    [median release];
}

- (void) dealloc
{
    [activeImage release];
    [super dealloc];
}

@end
