//
//  PRCustTraceEdges.m
//  PRICE
//
//  Created by Riccardo Mottola on Fri Mar 19 2004.
//  Copyright (c) 2004 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRCustTraceEdges.h"
#import "PRTraceEdges.h"
#import "PRMedian.h"
#import "PRGrayscaleFilter.h"
#import <math.h>
#import <limits.h>


@implementation PRCustTraceEdges

- (NSImage *)edgeImage :(NSImage *)srcImage :(int)filterType :(float)thresholdLevel :(BOOL)useZeroCross :(BOOL)enable1 :(enum medianForms)form1 :(int)size1 :(BOOL)separable1 :(BOOL)enable2 :(enum medianForms)form2 :(int)size2 :(BOOL)separable2 :(BOOL) enable3 :(enum medianForms)form3 :(int)size3 :(BOOL)separable3
{
    NSBitmapImageRep *srcImageRep;
    unsigned char *srcData;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    unsigned char *destData;
    NSImage *firstImage, *secondImage, *thirdImage;
    NSBitmapImageRep *firstImageRep, *secondImageRep, *thirdImageRep;
    unsigned char *fiData, *siData, *tiData;
    int w, h;
    int i;
    int bytesPerPixel;
    int pixNum;
    PRMedian *medianFilter;
    PRTraceEdges *edgeFilter;
    int finalLevels;
    int finalLevelSize;
    
    /* check the number of images to process */
    finalLevels = 0;
    if (enable1)
        finalLevels++;
    if (enable2)
        finalLevels++;
    if (enable3)
        finalLevels++;
    finalLevelSize = UCHAR_MAX / finalLevels;
    
    printf("Level number: %d\n", finalLevels);
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    pixNum = h * w;
    printf("pixels: %d\n", pixNum);
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    /* check bith depth and color/greyscale image */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
//            printf("Grayscale image\n");
        }
        else
        {
            PRGrayscaleFilter *grayFilter;
            grayFilter = [[PRGrayscaleFilter alloc] init];
            srcImage = [grayFilter filterImage:srcImage];
            [grayFilter release];
            NSLog (@"done greyscale converting");
            /* we reget previous information that is no longer valid */
            /* get source image representation and associated information */
            srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
            bytesPerPixel = [srcImageRep bitsPerPixel] /8;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {
            printf("Grayscale image\n");
        }
        else
        {
            PRGrayscaleFilter *grayFilter;
            grayFilter = [[PRGrayscaleFilter alloc] init];
            srcImage = [[grayFilter filterImage:srcImage] retain];
            [grayFilter release];
            NSLog (@"done greyscale converting");
            /* we reget previous information that is no longer valid */
            /* get source image representation and associated information */
            srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
            bytesPerPixel = [srcImageRep bitsPerPixel] /8;
        }
    }

    /* allocate destination image and its representation */
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    
    destData = [destImageRep bitmapData];
    
    /* let's make the paper white */
    memset(destData, UCHAR_MAX, pixNum);

    /* allocate filters */
    medianFilter = [[PRMedian alloc] init];
    edgeFilter   = [[PRTraceEdges alloc] init];

    if (finalLevels > 0)
    {
        if (enable1)
        {
            printf("filtering 1 ft:%d zc%d rl:%f\n", filterType, useZeroCross, thresholdLevel);
            firstImage  = [medianFilter medianImage :srcImage :form1 :size1 :separable1];
            firstImage  = [edgeFilter edgeImage :firstImage  :filterType :YES :thresholdLevel :useZeroCross];
            firstImageRep = [NSBitmapImageRep imageRepWithData:[firstImage TIFFRepresentation]];
            fiData = [firstImageRep bitmapData];
            for (i = 0; i < pixNum; i++)
            {
                if (*(fiData + i) == 0)
                    *(destData + i) -= finalLevelSize;
            }
        }
        
        if (enable2)
        {
            printf("filtering 2\n");
            secondImage = [medianFilter medianImage :srcImage :form2 :size2 :separable2];
            secondImage = [edgeFilter edgeImage :secondImage :filterType :YES :thresholdLevel :useZeroCross];
            secondImageRep = [NSBitmapImageRep imageRepWithData:[secondImage TIFFRepresentation]];
            siData = [secondImageRep bitmapData];
            for (i = 0; i < pixNum; i++)
            {
                if (*(siData + i) == 0)
                    *(destData + i) -= finalLevelSize;
            }
        }
        
        if (enable3)
        {
            printf("filtering 3\n");
            thirdImage  = [medianFilter medianImage :srcImage :form3 :size3 :separable3];
            thirdImage  = [edgeFilter edgeImage :thirdImage  :filterType :YES :thresholdLevel :useZeroCross];
            thirdImageRep = [NSBitmapImageRep imageRepWithData:[thirdImage TIFFRepresentation]];
            tiData = [thirdImageRep bitmapData];
            for (i = 0; i < pixNum; i++)
            {
                if (*(tiData + i) == 0)
                    *(destData + i) -= finalLevelSize;
            }
        }
    } else
    {
        /* no median processing */
        /* we conventionally process the image */
        srcImage  = [edgeFilter edgeImage :srcImage  :filterType :YES :thresholdLevel :useZeroCross];
        srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
        srcData = [srcImageRep bitmapData];
        for (i = 0; i < pixNum; i++)
        {
            if (*(srcData + i) == 0)
                *(destData + i) = 0;
        }
    }
    
    /* release filters */
    [medianFilter release];
    [edgeFilter release];

    
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

@end
