//
//  PRWindowController.h
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2002-2005 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <AppKit/AppKit.h>
#import "PRImageView.h"
#import "PRImage.h"


@interface PRWindowController : NSWindowController
{
    IBOutlet PRImageView *view;
    IBOutlet NSTextField *imageInfoLine;
    IBOutlet NSPanel     *scalePanel;
    IBOutlet NSTextField *scalePanelScaleField;
    
    float scale; /* image scaling factor */
}

- (void)scaleFromMenu:(id)sender;
- (void)scalePanelOk:(id)sender;
- (void)scalePanelCancel:(id)sender;
- (void)scaleImageTo:(float)internal_scale;
- (void)scaleImage;
- (void)setImageToDraw:(PRImage *)image;
- (void)setImageInfo:(PRImage *)image;
- (NSView *)view;

@end
