//
//  PRDFTLowPass.m
//  PRICE
//
//  Created by Riccardo Mottola on Sat Sep 13 2003.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRDFTLowPass.h"
#import "PRDFTFilter.h"
#import "FFT.h"
#import "math.h"

@implementation PRDFTLowPass

- (NSImage *)transformImage:(NSImage *)srcImage :(BOOL)autoRange :(float) BPFreq :(float) BSFreq
{
    PRDFTFilter *filter;
    double **Fa;
    unsigned int i, j;
    unsigned int w, h;
    unsigned int bitNum;
    unsigned int num;
    unsigned int halfNum;
    NSImage *destImage;
    float radius;
    
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    /* get source image representation and associated information */
    w = [[NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]] pixelsWide];
    h = [[NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]] pixelsHigh];

    /* we set the image square to the nearest power of two on the longer side */
    if (w > h)
        bitNum = binaryLog(w);
    else
        bitNum = binaryLog(h);
    num = binpow(bitNum);
    
    /* calculate the half comprising the zero */
    halfNum = (num >> 1);
    NSLog(@"halfNum %d", halfNum);
    
    /* allocate filter  matrix */
    Fa = (double**)calloc(num, sizeof(double*));
    for (i = 0; i < num; i++)
    {
        Fa[i] = (double*)calloc(num, sizeof(double));
        if (!Fa[i])
        {
            printf("out of memory allocating float matrix?\n");
            return srcImage;
        }
        memset(Fa[i], '\000', num);
    }
    
    /* calculate the filter */
    NSLog(@"BP %f, BS %f", BPFreq, BSFreq);
    /* top left quadrant */
    for (i = 0; i <= halfNum; i++)
        for (j = 0; j <= halfNum; j++)
        {
            radius = sqrt(i*i + j*j) / halfNum;
            if (radius < BPFreq)
            {
                Fa[i][j] = 1;
            } else if (radius < BSFreq)
            {
                Fa[i][j] = 0.5*(cos(M_PI*(radius-BPFreq)/(BSFreq-BPFreq))+1);
            }
        }

    /* top right quadrant */
    for (i = 0; i < halfNum; i++)
        for (j = 0; j < halfNum-1; j++)
            Fa[i][num - j - 1] = Fa[i][j];
    /* bottom left quadrant */
    for (i = 0; i < halfNum-1; i++)
        for (j = 0; j < halfNum; j++)
            Fa[num - i - 1][j] = Fa[i][j];
    /* bottom right quadrant */
    for (i = 0; i < halfNum-1; i++)
        for (j = 0; j < halfNum-1; j++)
            Fa[num - i - 1][num - j - 1] = Fa[i][j];
    
/*    
    for (i = 0; i < num; i++)
    {
        for (j = 0; j < num; j++)
        {
            printf("%2.1f ", Fa[i][j]);
        }
        printf("\n");
    } */
    /* instantiate the filter */
    filter = [[PRDFTFilter alloc] init];
    
    destImage = [filter filterImage :srcImage :Fa :NULL :num :autoRange];

/* filter display
    NSBitmapImageRep *destImageRep;
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    destImageRep = [[[NSBitmapImageRep alloc] \
                    initWithBitmapDataPlanes:NULL \
                    pixelsWide:w \
                    pixelsHigh:h \
                    bitsPerSample:8 \
                    samplesPerPixel:1 \
                    hasAlpha:NO \
                    isPlanar:NO \
                    colorSpaceName:NSCalibratedWhiteColorSpace \
                    bytesPerRow:0 \
                    bitsPerPixel:0] \
                autorelease];
                
    destData = [destImageRep bitmapData];
    double sample;
    int x, y;
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                sample = rint(Fa[x][y]*UCHAR_MAX);
                if (sample > UCHAR_MAX)
                    sample = UCHAR_MAX;
                else if (sample < 0)
                    sample = 0;
                destData[y*w + x] = (unsigned char) sample;
            }
    [destImage addRepresentation:destImageRep];  */     
    /* now we free our filter matrix */
    for (i = 0; i < num; i++)
        free(Fa[i]);
    free(Fa);

    return destImage;
}


@end
