(defvar prime-engine-select-row 0)
(defvar prime-engine-select-list nil)

;; $B%-!<%^%C%W$N@_Dj(B
(defvar prime-engine-select-mode-map nil)
(or prime-engine-select-mode-map
    (let ((map (make-sparse-keymap)))
      (define-key map "q" 'prime-engine-select-save-and-exit)
      (define-key map " " 'prime-engine-select-enter)
      (define-key map "\C-m" 'prime-engine-select-enter)
      (substitute-key-definition 'previous-line
				 'prime-engine-select-prev map global-map)
      (substitute-key-definition 'next-line
				 'prime-engine-select-next map global-map)
      (setq prime-engine-select-mode-map map)
      ))

(defun prime-engine-select-mode ()
  (interactive)
  (setq prime-engine-select-list (copy-alist prime-engine-list))
  (use-local-map prime-engine-select-mode-map)
  (setq mode-name "PRIME Engine")
  (setq major-mode 'prime-engine-select-mode)
  )

(defun prime-engine-select ()
  (interactive)
  (pop-to-buffer " *prime-engines*")
  (prime-engine-select-mode)
  (prime-engine-disp-list)
  )

(defun prime-engine-disp-list ()
  (toggle-read-only -1)
  (erase-buffer)
  (let ((target (nth prime-engine-select-row prime-engine-select-list))
	(cursor-point (point)))
    (mapcar
     (lambda (engine)
       (and (eq target engine) (setq cursor-point (+ 2 (point))))
       (insert (format "%1s%s %-30s %-24s\t%1s\n"
		       (if (eq target engine) "[" " ")
		       (if (cdr engine)
			   (if (eq (prime-engine-status engine) 'error)
			       "E" "+") "-")
		       (symbol-name (car engine)) (prime-engine-name engine)
		       (if (eq target engine) "]" " ")
		       )))
     prime-engine-select-list)

    (insert "\n" (make-string 50 ? ))

    (if (= prime-engine-select-row (length prime-engine-select-list))
	(progn (setq cursor-point (1+ (point)))
	       (insert "[ OK ]"))
      (insert "  OK  "))

    (if (= prime-engine-select-row (1+ (length prime-engine-select-list)))
	(progn (setq cursor-point (1+ (point)))
	       (insert "[ $B%-%c%s%;%k(B ]"))
      (insert "  $B%-%c%s%;%k(B  "))

    (insert "\n " (make-string 71 ?-) "\n\n")
    (insert (prime-engine-comment target))
    (goto-char cursor-point)
    )
  (toggle-read-only t)
  )

(defun prime-engine-select-prev ()
  (interactive)
  (setq prime-engine-select-row (max 0 (1- prime-engine-select-row)))
  (prime-engine-disp-list)
  )

(defun prime-engine-select-next ()
  (interactive)
  (setq prime-engine-select-row (min (1+ (length prime-engine-list))
				     (1+ prime-engine-select-row)))
  (prime-engine-disp-list)
  )

(defun prime-engine-select-enter ()
  (interactive)
  (cond
   ((= prime-engine-select-row (1+ (length prime-engine-list)))
    (prime-engine-select-exit))
   ((= prime-engine-select-row (length prime-engine-list))
    (prime-engine-select-save-and-exit))
   (t
    (let* ((engine-cons (nth prime-engine-select-row prime-engine-select-list))
	   (status (if (cdr engine-cons) 
		       (if (eq (prime-engine-status engine-cons) 'error)
			   'error t) nil)))
      (if (eq status 'error)
	  (if (yes-or-no-p "$B:F@\B3$r9T$$$^$9$+(B? ")
	      (prime-engine-init engine-cons t))
	(setcdr engine-cons (not status)))
      (prime-engine-disp-list)
      ))
   ))

(defun prime-engine-select-exit ()
  (interactive)
  (delete-window)
  )

(defun prime-engine-select-save-and-exit ()
  (interactive)
  (setq prime-engine-list prime-engine-select-list)
  (prime-server-init)
  (delete-window)
  (prime-set-cands prime-pat t)
  (prime-cand-set-column-list) ;; $B1#JC$G$-$k$H$$$$$J(B.
  (and prime-input-mode
       (prime-disp-input))
  )

(provide 'prime-engine-mode)
