#!/bin/sh
#
# FreeBSD init script for printbill - put it in /usr/local/etc/rc.d

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/local/sbin/printbilld
NAME=printbilld
DESC="printbill daemon"
CONF=/etc/printbill/printbillrc
PRINTCAP=/usr/local/etc/printcap
PSHOWALL="-ax"

test -x $DAEMON || exit 0

if [ ! -e $CONF ] ; then
	echo "error: printbill not configured yet - run printbill_configure"
	exit 0
fi

if [ ! -e $PRINTCAP ] ; then
	echo "warning: printcap not found, but proceeding anyway"
else
	grep printbill_scheduler\\\|printbill_accountonly\\\|printbill_quote\\\|printbill_lazybill $PRINTCAP > /dev/null

	if [ $? = 0 ] ; then
		echo "warning: obsolete entry in $PRINTCAP"
	fi
	
	grep 'printbill --type' $PRINTCAP > /dev/null
	
	if [ $? != 0 ] ; then
		echo "warning: no printbill lines in $PRINTCAP, starting printbill daemon anyway"
	fi
fi

DB_HOME=`grep db_home $CONF | awk '{print $2}'`

if [ ! -d $DB_HOME ] ; then
	echo "error: no $DB_HOME - run pqm --init to set this up"
	exit 0;
fi

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	$DAEMON || true
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	kill -INT `ps ${PSHOWALL} | awk '/printbilld/{ print $1;}'` >/dev/null 2>&1
	echo "$NAME."
	;;
  restart)
	$0 stop
	sleep 1
	$0 start
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	exit 1
	;;
esac

exit 0
