/***************************************************************************
                          helper.c  -  description
                             -------------------
    begin                : Sun Aug 25 2002
    copyright            : (C) 2002 by Jan Fernquist, Florian Boor
    email                : boor@unix-ag.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gdk/gdk.h>
#include "helper.h"
#include "prismstumbler.h"

extern int sock; /* communication socket, defined in main-fe.c */
extern psconfig_t cfg; /* current configuration */
extern gboolean night_mode;

/* checks if a string is not emty, valid and displayable */
inline int 
check_str_content(char *astr)
{
	int len,i;
	if (!astr) return FALSE;
	if ((len = strlen(astr)) == 0) return FALSE;
	if (!isalnum(astr[0])) return FALSE;
	for (i=0;i<len;i++){
		if (isalnum(astr[i]) &&  
			!isspace(astr[i])) return TRUE;
	}	
	return FALSE;
}


/* returns a color for row marking */
char *
calc_color (gushort color, int variant)
{
	GdkColor result;
	char *res;

	result.pixel = 0;
	if (night_mode)
	{
		result.red = 0;
		if (variant) 
			result.blue = 65534;
		else
			result.blue = 0;
		result.green = 65535 - color;
	}
	else
	{
		result.red = 65534;
		if (variant) 
			result.blue = 0;
		else
			result.blue = 65534;
		result.green = color;
	}
	res = g_strdup_printf ("#%.2X%.2X%.2X", result.red / 256,
			       result.green / 256, result.blue / 256);

	return res;
}

/* sends current configuration to peer*/
void
send_config ()
{
	psmessage_t msg;
	msg.type = msg_config;
	msg.content.cfg = cfg;
	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
	{
		perror ("err sending config data");
	}
}

/* sends a command to peer */
void
send_command (command_t cmd, int par)
{
	psmessage_t msg;
	msg.type = msg_command;
	msg.content.command.command = cmd;
	msg.content.command.par = par;

	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
	{
		perror ("err sending command");
	}
}


void
send_usernet (usernetinfo_t * usernet)
{
	psmessage_t msg;
	msg.type = msg_usernet;
	msg.content.usernet = *usernet;

	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
	{
		perror ("err sending user netinfo");
	}
}
