/*
 * prismstumbler wireless lan analyzing tool
 *
 * Copyright (C) 2000 and created by Jan Fernquist  <Jan.B.Fernquist@telia.com>
 * Copyright (C) 2003 Florian Boor <florian.boor@kernelconcepts.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * GTK+ frontend 
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <gtk/gtk.h>
#include "prismstumbler.h"
#include "interface.h"
#include "support.h"


#define HELPTEXT "Call with no parameters or with the following options\n\
	-S Channel   - Only listen on a specific Channel (1-14)\n\
	-w FileName  - Create (and update) Gpsdrive Waypointfile\n\
	-d Database only mode (scanner inactive)\n\
	-o Use orinoco driver interface\n\
	-h Use hostap driver interface\n\
	-i Interface - Use designated interface\n\n"

const char *dhcpcommands[] = {
	"/sbin/dhcpcd %s &",
	"/sbin/dhclient %s &",
	"/sbin/udhcpc -i %s &",
	"/usr/sbin/dhcpcd %s &",
	"/usr/sbin/udhcpc -i %s &"
};

/* /tmp is a good choice for fast changing files on PDAs, because it usually
is not located on flash*/
psconfig_t cfg = { 0, "eth0", DT_ORINOCO, 40000, 0 ,0, TRUE,"/tmp/spotkoord.txt", "/tmp/psdump.pcap", FALSE, 0};
char* cfgfile;
int sock;
int driver_set = FALSE;
int QUIET_MODE = 1;


void
HelpAndBye (void)
{
	fprintf (stderr, "%s", HELPTEXT);
	exit (1);
}


int
main (int argc, char *argv[])
{
	GtkWidget *fMain;
	int c;
	struct sockaddr_un name;

	gtk_init (&argc, &argv);

	cfgfile = g_strdup_printf("%s/%s",g_get_home_dir(),".pstumbler/prismstumblerrc");	

	while ((c = getopt (argc, argv, "dS:F:w:i:oh")) != EOF)
	{
		switch (c)
		{
		case 'S':
		{
			cfg.singlechan = atoi (optarg);
			if (cfg.singlechan < 1
			    || cfg.singlechan > 14)
			{
				HelpAndBye ();
			}
			break;
		}

		case 'w':
			snprintf(cfg.wpfile,255,optarg);
			break;
		case 'd':
			cfg.scan = FALSE;
			break;
		case 'o':
			cfg.devtype = DT_ORINOCO;
			driver_set = TRUE;
			break;
		case 'h':
			cfg.devtype = DT_HOSTAP;
			driver_set = TRUE;
			break;
		case 'i':
			snprintf (cfg.device, 6, "%s", optarg);
			break;
		case '?':
			HelpAndBye ();
			break;
		}
	}


	/* Create socket from which to read. */
	sock = socket (AF_UNIX, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror ("opening datagram socket");
		exit (1);
	}

	/* Create name. */
	name.sun_family = AF_UNIX;
	strcpy (name.sun_path, PS_SOCKET);
	if (connect (sock, (struct sockaddr *) &name, SUN_LEN (&name)))
	{
		perror ("connecting to socket");
		exit (1);
	}
	
	fMain = create_fMain ();
	gtk_widget_show_all (fMain);
	gtk_main ();

	close(sock);
	
	return 0;
}
