# Profanity
[![Build Status](https://api.travis-ci.org/profanity-im/profanity.png?branch=master)](https://travis-ci.org/profanity-im/profanity) [![builds.sr.ht status](https://builds.sr.ht/~wstrm/profanity.svg)](https://builds.sr.ht/~wstrm/profanity?) [![Chat](https://inverse.chat/badge.svg?room=profanity@rooms.dismail.de)](https://conversations.im/j/profanity@rooms.dismail.de) [![Packaging status](https://repology.org/badge/tiny-repos/profanity.svg)](https://repology.org/project/profanity/versions) [![GitHub contributors](https://img.shields.io/github/contributors/profanity-im/profanity.svg)](https://github.com/profanity-im/profanity/graphs/contributors/)

Profanity is a console based XMPP client inspired by [Irssi](http://www.irssi.org/).

If you like Profanity consider becoming a sponsor or [donate](https://profanity-im.github.io/donate.html) some money.

![alt tag](https://profanity-im.github.io/images/prof-2.png)

See the [User Guide](https://profanity-im.github.io/userguide.html) for information on installing and using Profanity.

## Project
This project is about freedom, privacy and choice. We want to enable people to chat with one another in a safe way. Thus supporting encryption (OTR, PGP, OMEMO) and being decentralized, meaning everyone can run their own server. We believe [XMPP](https://xmpp.org/) is a great proven protocol with an excellent community serving this purpose well.

Feel free to follow us on [twitter](https://twitter.com/profanityim), join our [mailing list](https://lists.notraces.net/mailman/listinfo/profanity) and/or [MUC](xmpp:profanity@rooms.dismail.de?join).

## Installation
Our [user guide](https://profanity-im.github.io/userguide.html) contains an [install](https://profanity-im.github.io/guide/latest/install.html) section and a section for [building](https://profanity-im.github.io/guide/latest/build.html) from source yourself.

## Donations
We would highly appreciate it if you support us via [GitHub Sponsors](https://github.com/sponsors/jubalh/). Especially if you make feature requests or need help using Profanity.
Sponsoring enables us to spend time on Profanity.

GitHub matches every donation in the first year.

An alternative way to support us would be via [Patreon](https://www.patreon.com/jubalh) or ask for our IBAN.

Issues backed by a sponsor will be tagged with the [sponsored](https://github.com/profanity-im/profanity/issues?q=label%3Asponsored+) label.
Feature requests that we consider out of scope, either because of interest or because of time needed to implement them, will be marked with the [unfunded](https://github.com/profanity-im/profanity/issues?q=label%3Aunfunded) label.

Another way to sponsor us or get an issue solved is to create a [bug bounty](https://www.bountysource.com/teams/profanity/issues).
Here one sets a bounty on a certain task and once the task is completed you send the money to the person who did the work.

Tasks from our [sponsors](SPONSORS.md) will be tackled first.

Thank you! <3

## How to contribute
We tried to sum things up on our [helpout](https://profanity-im.github.io/helpout.html) page.
Additionally you can check out our [blog](https://profanity-im.github.io/blog/) where we have articles like:
[How to get a backtrace](https://profanity-im.github.io/blog/post/how-to-get-a-backtrace/) and [Contributing a Patch via GitHub](https://profanity-im.github.io/blog/post/contributing-a-patch-via-github/).

## Getting help
To get help, first read our [User Guide](https://profanity-im.github.io/userguide.html) then check out the [FAQ](https://profanity-im.github.io/faq.html).
If you have are having a problem then first search the [issue tracker](https://github.com/profanity-im/profanity/issues).
If you don't find anything there either come to our [MUC](xmpp:profanity@rooms.dismail.de?join) or create a new issue depending on what your problem is.

## Links

### Website
URL: https://profanity-im.github.io

Repo: https://github.com/profanity-im/profanity-im.github.io

### Blog
URL: https://profanity-im.github.io/blog

Repo: https://github.com/profanity-im/blog

### Mailinglist 
Mailing List: https://lists.notraces.net/mailman/listinfo/profanity

Thanks to @toogley!

### Chatroom
MUC: profanity@rooms.dismail.de

### Plugins
Plugins repository: https://github.com/profanity-im/profanity-plugins
