/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.MemberInfoObfuscator;

public class MemberInfoNameConflictFixer
implements MemberInfoVisitor {
    private boolean allowAggressiveOverloading;
    private Map descriptorMap;
    private WarningPrinter warningPrinter;
    private MemberInfoObfuscator memberInfoObfuscator;

    public MemberInfoNameConflictFixer(boolean bl, Map map, WarningPrinter warningPrinter, MemberInfoObfuscator memberInfoObfuscator) {
        this.allowAggressiveOverloading = bl;
        this.descriptorMap = map;
        this.warningPrinter = warningPrinter;
        this.memberInfoObfuscator = memberInfoObfuscator;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo, true);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = programMethodInfo.getName(programClassFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        this.visitMemberInfo(programClassFile, programMethodInfo, false);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo, boolean bl) {
        String string;
        Map map;
        String string2;
        String string3 = memberInfo.getName(classFile);
        String string4 = memberInfo.getDescriptor(classFile);
        if (!this.allowAggressiveOverloading) {
            string4 = string4.substring(0, string4.indexOf(41) + 1);
        }
        if (!string3.equals(string2 = (String)(map = MemberInfoObfuscator.retrieveNameMap(this.descriptorMap, string4)).get(string = MemberInfoObfuscator.newMemberName(memberInfo)))) {
            if (MemberInfoObfuscator.hasFixedNewMemberName(memberInfo) && this.warningPrinter != null) {
                string4 = memberInfo.getDescriptor(classFile);
                this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(classFile.getName()) + (bl ? ": field '" + ClassUtil.externalFullFieldDescription(0, string3, string4) : ": method '" + ClassUtil.externalFullMethodDescription(classFile.getName(), 0, string3, string4)) + "' can't be mapped to '" + string + "' because it would conflict with " + (bl ? "field '" : "method '") + string2 + "', which is already being mapped to '" + string + "'");
            }
            MemberInfoObfuscator.setNewMemberName(memberInfo, null);
            memberInfo.accept(classFile, this.memberInfoObfuscator);
        }
    }
}

