/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <iostream>
#include <sstream>

#include "CPfCoachContractsDAOSQLite.h"

CPfCoachContractsDAOSQLite::CPfCoachContractsDAOSQLite(sqlite3 *database)
  : CPfCoachContractsDAOSQLiteEntity(database)
{
}

CPfCoachContractsDAOSQLite::~CPfCoachContractsDAOSQLite()
{
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findByXCoachContract(int XCoachContract)
{
    std::ostringstream stream;
    stream << XCoachContract;
    return findByXCoachContract(stream.str());
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findByXCoachContract(const std::string &XCoachContract)
{
    std::string sql("SELECT * FROM PF_COACH_CONTRACTS WHERE ");
    sql = sql+"X_COACH_CONTRACT='"+XCoachContract+"'";
    return loadRegister(sql);
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findByXFkCoach(int XFkCoach)
{
    std::ostringstream stream;
    stream << XFkCoach;
    return findByXFkCoach(stream.str());
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findByXFkCoach(const std::string &XFkCoach)
{
    std::string sql("SELECT * FROM PF_COACH_CONTRACTS WHERE ");
    sql = sql+"X_FK_COACH='"+XFkCoach+"'";
    return loadRegister(sql);
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findActiveByXFkTeam(int XFkTeam, const std::string &timestamp)
{
    std::ostringstream stream;
    stream << XFkTeam;
    return findActiveByXFkTeam(stream.str(), timestamp);
}

CPfCoachContracts* CPfCoachContractsDAOSQLite::findActiveByXFkTeam(const std::string &XFkTeam, const std::string &timestamp)
{
    std::string sql("SELECT * FROM PF_COACH_CONTRACTS WHERE ");
    sql = sql+"X_FK_TEAM='"+XFkTeam+"' ";
    sql = sql+"  AND D_BEGIN<='" + timestamp + "' AND (D_END IS NULL OR D_END>'" + timestamp + "')";
    return loadRegister(sql);
}

std::vector<CPfCoachContracts*>* CPfCoachContractsDAOSQLite::findByXFkCoachAndXSeason(int XFkCoach, int XSeason)
{
    std::ostringstream streamCoach;
    streamCoach << XFkCoach;
    std::ostringstream streamSeason;
    streamSeason << XSeason;
    return findByXFkCoachAndXSeason(streamCoach.str(), streamSeason.str());
}

std::vector<CPfCoachContracts*>* CPfCoachContractsDAOSQLite::findByXFkCoachAndXSeason(const std::string &XFkCoach, const std::string &XSeason)
{
    std::string sql("SELECT * FROM PF_COACH_CONTRACTS WHERE ");
    sql = sql+" X_FK_COACH='"+XFkCoach+"'";
    sql = sql+" AND D_BEGIN <= (SELECT MAX(D_END_COMPETITION) ";
    sql = sql+            "FROM PF_COMPETITIONS_BY_SEASON CS ";
    sql = sql+            "JOIN PF_SEASONS S ON S.X_SEASON = CS.X_FK_SEASON ";
    sql = sql+            "WHERE S.X_SEASON = "+XSeason+")";
    sql = sql+" AND (D_END >= (SELECT MIN(D_BEGIN_COMPETITION) ";
    sql = sql+            "FROM PF_COMPETITIONS_BY_SEASON CS ";
    sql = sql+            "JOIN PF_SEASONS S ON S.X_SEASON = CS.X_FK_SEASON ";
    sql = sql+            "WHERE S.X_SEASON = "+XSeason+")";
    sql = sql+" OR D_END IS NULL) ";
    return loadVector(sql);
}
