/*
    BreakpointsStore.h

    Interface declaration of the BreakpointsStore class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSString, NSMutableArray, NSArray;

/**
 * Posted every time a breakpoint is added or removed.
 */
extern NSString * const BreakpointsDidChangeNotification;

@interface BreakpointsStore : NSObject
{
  /**
   * Array elements are dictionaries of the following structure:
   *
   * {
   *   Filename = "<filename>";
   *   Line = (NSNumber *) lineNumber;
   * }
   *
   * or
   *
   * {
   *   Symbol = "<symbol-name>";
   * }
   */
  NSMutableArray * breakpoints;
}

+ shared;

- (void) addBreakpointInFile: (NSString *) filename
                        line: (unsigned int) lineNumber;

- (void) addBreakpointOnSymbol: (NSString *) symbol;

- (void) removeBreakpointInFile: (NSString *) filename
                           line: (unsigned int) lineNumber;

- (void) removeBreakpointOnSymbol: (NSString *) symbol;

/**
 * Returns all breakpoints defined.
 */
- (NSArray *) breakpoints;

/**
 * Returns line-based breakpoints in a certain file.
 */
- (NSArray *) breakpointsInFile: (NSString *) filename;

@end
