/*
    DebuggerLoader.m

    Implementation of the DebuggerLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "DebuggerLoader.h"

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>

#import "DebuggerProtocol.h"
#import "BundleExtensionLoader.h"

@implementation DebuggerLoader

static DebuggerLoader * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- init
{
  if ([super init])
    {
      /* load all debugger bundles */

      NSMutableDictionary * dbgTypes;
      NSArray * bundles;
      NSBundle * bundle;
      NSEnumerator * e;

      bundles = [[BundleExtensionLoader shared]
        extensionsForBundleType: @"debugger"
         principalClassProtocol: @protocol(Debugger)
             bundleSubdirectory: @"ProjectManager"
                      inDomains: 0
           domainDetectionByKey: @"Debuggers"];

      dbgTypes = [NSMutableDictionary dictionaryWithCapacity: [bundles count]];

      e = [bundles objectEnumerator];
      while ((bundle = [e nextObject]) != nil)
        {
          Class principalClass = [bundle principalClass];

          [dbgTypes setObject: principalClass
                       forKey: [principalClass debuggerTypeID]];
        }

      ASSIGNCOPY(debuggerTypes, dbgTypes);

      return self;
    }
  else
    {
      return nil;
    }
}

- (NSDictionary *) debuggerTypes
{
  return debuggerTypes;
}

- (id <Debugger>) debuggerForTypeID: (NSString *) debuggerTypeID
                            project: (ProjectDocument *) project
{
  Class debuggerCls;

  debuggerCls = [debuggerTypes objectForKey: debuggerTypeID];

  return [[[debuggerCls alloc]
     initWithOwner: project]
    autorelease];
}

@end
