/*
    AggregateProjectType.m

    Implementation of the AggregateProjectType class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "AggregateProjectType.h"

#import <Foundation/NSString.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>

#import "../../ProjectDocument.h"

static void
InsertMakefileEnumerationVariable(NSMutableString * makefileString,
                                  NSString * name,
                                  NSArray * values)
{
  NSEnumerator * e;
  NSString * value;

  [makefileString appendString: [NSString stringWithFormat:
    @"\n"
    @"%@ = ", name]];
  e = [values objectEnumerator];
  while ((value = [e nextObject]) != nil)
    {
      [makefileString appendString: [NSString stringWithFormat: @"%@ \\\n",
        value]];
    }
}

@implementation AggregateProjectType

+ (NSString *) projectTypeID
{
  return @"Aggregate";
}

+ (NSString *) humanReadableProjectTypeName
{
  return _(@"Aggregate");
}

+ (NSString *) projectTypeDescription
{
  return [NSString stringWithContentsOfFile:
    [[NSBundle bundleForClass: self]
    pathForResource: @"Description" ofType: @"txt"]];
}

+ (NSImage *) projectTypeIcon
{
  return nil;
}

+ (int) projectCapabilities
{
  return BuildProjectCapability | SubprojectsProjectCapability;
}

+ (NSDictionary *) projectTemplateDescriptions
{
  NSBundle * myBundle = [NSBundle bundleForClass: self];

  return [NSDictionary dictionaryWithObjectsAndKeys:
    _(@"An empty aggregate project."), _(@"Empty"),
    nil];
}

+ (NSString *) pathToProjectTemplate: (NSString *) templateName
{
  return [[NSBundle bundleForClass: self]
    pathForResource: @"Empty" ofType: @"template"];
}

- initWithOwner: (ProjectDocument *) anOwner
 infoDictionary: (NSDictionary *) infoDict
{
  if ([self init])
    {
      owner = anOwner;

      return self;
    }
  else
    {
      return nil;
    }
}

- (NSDictionary *) infoDictionary
{
  return nil;
}

- (BOOL) prepareForBuild
{
  NSString * buildDir = [owner projectDirectory];
  NSMutableString * makefileString = [NSMutableString string];

  [makefileString appendString:
    @"\n"
    @"include $(GNUSTEP_MAKEFILES)/common.make\n"];

  // prepend some definitions to turn on compiler warnings as necessary
  [makefileString appendString:
    @"\n"
    @"ifeq ($(warnings), yes)\n"
    @"ADDITIONAL_OBJCFLAGS += -W\n"
    @"ADDITIONAL_OBJCPPFLAGS += -W\n"
    @"ADDITIONAL_CFLAGS += -W\n"
    @"ADDITIONAL_CPPFLAGS += -W\n"
    @"endif\n"
    @"ifeq ($(allwarnings), yes)\n"
    @"ADDITIONAL_OBJCFLAGS += -Wall\n"
    @"ADDITIONAL_OBJCPPFLAGS += -Wall\n"
    @"ADDITIONAL_CFLAGS += -Wall\n"
    @"ADDITIONAL_CPPFLAGS += -Wall\n"
    @"endif\n"];

  // SUBPROJECTS
  {
    NSArray * subprojectNames = [[owner subprojects] allKeys];
    NSEnumerator * e = [subprojectNames objectEnumerator];
    NSString * subprojectName;
    NSMutableArray * subprojects = [NSMutableArray arrayWithCapacity:
      [subprojectNames count]];

    while ((subprojectName = [e nextObject]) != nil)
      {
        [subprojects addObject: [[self pathToSubprojectsDirectory]
          stringByAppendingPathComponent: subprojectName]];
      }

    InsertMakefileEnumerationVariable(makefileString,
                                      @"SUBPROJECTS",
                                      subprojects);
  }

  [makefileString appendString:
    @"\n"
    @"include $(GNUSTEP_MAKEFILES)/aggregate.make\n"];

  return [makefileString writeToFile: 
    [buildDir stringByAppendingPathComponent: @"GNUmakefile"]
                          atomically: NO];
}


- (NSString *) pathToFileTemplatesDirectoryForCategory: (NSString *) category
{
  return nil;
}

- (BOOL) canAddCategoriesToCategory: (NSString *) category
{
  return NO;
}

- (BOOL) canAddFilesToCategory: (NSString *) category
{
  return NO;
}

- (BOOL) canDeleteCategory: (NSString *) category
{
  return NO;
}

- (NSString *) pathToFile: (NSString *) fileName
               inCategory: (NSString *) category
{
  return nil;
}

- (NSString *) pathToSubprojectsDirectory
{
  return [[owner projectDirectory]
    stringByAppendingPathComponent: @"Subprojects"];
}

- (NSImage *) iconForCategory: (NSString *) category
{
  return nil;
}

- (NSDictionary *) projectAttributeViews
{
  return nil;
}

- (NSArray *) permissibleFileTypesInCategory: (NSString *) category
{
  return nil;
}

- (NSString *) pathToProjectBinaryOfType: (int) type
{
  return nil;
}

- (NSString *) debuggerType
{
  return nil;
}

- (NSArray *) fixedFrameworks
{
  return nil;
}

@end
