/*
    ProjectWizzard.h

    Interface declaration of the ProjectWizzard class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSArray;

@class NSTableView, NSTableColumn;

typedef enum {
  WizzardNext,
  WizzardPrevious,
  WizzardCancel
} WizzardResult;

@interface ProjectWizzard : NSObject
{
  NSArray * info;

  id description;
  id icon;
  id table;
  id panel;
  id titleField;
  id nextButton;
}

+ shared;

- (void) setTitle: (NSString *) aTitle;
- (NSString *) title;

- (void) setNextButtonTitle: (NSString *) nextButtonTitle;
- (NSString *) nextButtonTitle;

/**
 * Runs the panel in a modal session, showing the provided `info'.
 * The info array should be structured like this:
 *
 * (
 *   {
 *     Name = "Short Entry Name";
 *     Description = "Longer, more detailed entry description.";
 *     Icon = <entry-icon-image>;
 *   },
 *   ...
 * )
 */
- (WizzardResult) runModalWithInfo: (NSArray *) info;

/**
 * Returns the index of the selected item in the panel.
 */
- (int) selectedItem;

- (void) previous: (id)sender;
- (void) next: (id)sender;
- (void) cancel: sender;
- (void) selectItem: sender;

- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id)            tableView: (NSTableView *)aTableView 
  objectValueForTableColumn: (NSTableColumn *)aTableColumn 
                        row: (int)rowIndex;

@end
