/*
    ProjectWizzard.m

    Implementation of the ProjectWizzard class for the ProjectManager
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectWizzard.h"

#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>

#import <AppKit/NSTextView.h>
#import <AppKit/NSImageView.h>
#import <AppKit/NSScrollView.h>
#import <AppKit/NSTableView.h>
#import <AppKit/NSTableColumn.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSButtonCell.h>

@implementation ProjectWizzard

static ProjectWizzard * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- (void) dealloc
{
  TEST_RELEASE(info);

  [super dealloc];
}

- init
{
  if ([super init])
    {
      [NSBundle loadNibNamed: @"ProjectWizzard" owner: self];

      return self;
    }
  else
    {
      return nil;
    }
}

- (void) setTitle: (NSString *) aTitle
{
  [titleField setStringValue: aTitle];
}

- (NSString *) title
{
  return [titleField stringValue];
}

- (void) setNextButtonTitle: (NSString *) aTitle
{
  if (aTitle == nil)
    {
      [nextButton setTitle: _(@"Next")];
    }
  else
    {
      [nextButton setTitle: aTitle];
    }
}

- (NSString *) nextButtonTitle
{
  return [nextButton title];
}

- (void) awakeFromNib
{
  [[description enclosingScrollView] setHasVerticalScroller: NO];
  [[nextButton cell] setImageDimsWhenDisabled: YES];
}

- (WizzardResult) runModalWithInfo: (NSArray *) someInfo
{
  WizzardResult result;

  ASSIGN(info, someInfo);

  [table reloadData];
  [table selectRow: 0 byExtendingSelection: NO];
  [self selectItem: nil];

  [nextButton becomeFirstResponder];
  result = [NSApp runModalForWindow: panel];
  [panel close];

  return result;
}

- (int) selectedItem
{
  return [table selectedRow];
}

- (void) previous: (id)sender
{
  [NSApp stopModalWithCode: WizzardPrevious];
}


- (void) next: (id)sender
{
  [NSApp stopModalWithCode: WizzardNext];
}

- (void) cancel: sender
{
  [NSApp stopModalWithCode: WizzardCancel];
  
}
- (void) selectItem: sender
{
  int idx = [table selectedRow];

  if (idx < 0)
    {
      [icon setImage: nil];
      [description setText: nil];

      [nextButton setEnabled: NO];
    }
  else
    {
      NSDictionary * infoDict = [info objectAtIndex: idx];

      [icon setImage: [infoDict objectForKey: @"Image"]];
      [description setText: [infoDict objectForKey: @"Description"]];

      [nextButton setEnabled: YES];
    }
}

- (int) numberOfRowsInTableView: (NSTableView *)aTableView
{
  return [info count];
}

- (id)            tableView: (NSTableView *)aTableView 
  objectValueForTableColumn: (NSTableColumn *)aTableColumn 
                        row: (int)rowIndex
{
  return [[info objectAtIndex: rowIndex] objectForKey: @"Name"];
}

@end
