/***************************************************************************
                          supermountwatcher.h  -  description
                             -------------------
    begin                : Mon Oct 3 2004
    copyright            : (C) 2004 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SUPERMOUNTWATCHER_H
#define SUPERMOUNTWATCHER_H

#include "prokyon.h"

#include <qthread.h>
#include <qmap.h>

class SupermountWatcher : public QThread  {
 public: 
  SupermountWatcher();
  
  void run();
  void stop();
  void pause();
  void proceed();
  void addDevice(QString device, QString dir);
  
 private:
  QMutex mutex;
  bool stopCalled;
  bool paused;
  QMap<QString, QString> deviceStates;
  QMap<QString, QString> deviceMountpoints;
};

#endif
