/*-----------------------------------------------------------------------
QMBTagger - Qt Based MusicBrainz MP3/OGG/FLAC Tagger
Copyright (C) 2003,2004 Ewen Cheslack-Postava
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------*/

#include "qmbmp3file.h"

#if HAVE_LIBMUSICBRAINZ
#if HAVE_LIBMAD

#include "qmbfile.h"
#include <stdio.h>
#include <string.h>
#include <qapplication.h>
#include <qstring.h>
#include <musicbrainz/musicbrainz.h>
#include "qmbmad.h"
//#include <fstream>

QMBMP3File::QMBMP3File()
: QMBFile() {
    //we do nothing here.  we want to allow checking of return value,
    //so we only allow class to function through calling of Extract()
}

//get the data we want from the vorbis stream
//heavily borrowed code from vorbis doc on decoding vorbis stream
//returns:
//  0  indicates success
//  -1 indicates failed to open
//  -2 indicates invalid info
//  -3 indicates decoder failure
//  1 indicates success, but metadata extraction failed
int QMBMP3File::Extract(QString filename) {

    FILE* file = NULL;
    int bitrate, durationmilli, samplesint;
    int ret = 0;

    //record the full filename so we will be able to use it for output
    fullfilename = filename;

    //set the filename in the metadata
    int lastslash = filename.findRev('/');
    metadata.SetFileName(filename.right(filename.length() - lastslash - 1));

    //get the file's info
    MusicBrainz mb;
    std::string strfilename = filename.latin1(); //FIXME: change this to use QString if possible
    if (mb.GetMP3Info(strfilename, durationmilli, bitrate, channels, samplesint)) {
        metadata.SetDuration(QString::number(durationmilli));
        songlength = durationmilli/1000.;
        channels++; //this is because GetMP3Info reports single channel as 0 and stereo as 1
        sampleRate = samplesint;
        bits_per_sample = 16; //we set this in the decoder, so there is no possibility of it changing
    } else {
        qWarning("QMBMP3File::Extract(): GetMP3Info failed on file (%s).", fullfilename.local8Bit().data());
        return -2;
    }

    //if the info is invalid, return without doing anything
    if (channels == 0 || sampleRate == 0) {
        qWarning("QMBMP3File::Extract(): Channels (%d) or SampleRate (%ld) not set properly for file (%s).", channels, sampleRate, fullfilename.local8Bit().data());
        return -2;
    }

    //if the trmid was read in with the metadata, quit now
    if (!metadata.GetTRMID().isEmpty())
        return 0;

    //now for the actual decoding
    file = fopen(fullfilename.latin1(), "r");
    if (file == NULL) {
        qWarning("QMBMP3File::Extract(): Couldn't open file (%s) for reading.", fullfilename.local8Bit().data());
        return -1;
    }

    //figure out buffer length, we want 30 seconds of data,
    //get rate and channels from vorbis file, and
    //specify 16 bit (2 byte) samples
    //= channels*30 sec*rate*2bytes
    bufferlen = 30*channels*sampleRate*bits_per_sample/8;

    //create the actual buffer
    buffer = new char[bufferlen];

    //read the mp3
    QMBmad::ReadMPEG(file, buffer, bufferlen);

    //we're finished, just need to clean up
    fclose(file);

    return ret;
}

#endif /* HAVE_LIBMAD */
#endif /*HAVE_LIBMUSICBRAINZ*/
