/***************************************************************************
                          tagger_vorbiscomment.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if (HAVE_OGG) || (HAVE_FLAC)
#include "tagger_vorbiscomment.h"

#include <stdio.h>
#include <stdlib.h>
#include <qfileinfo.h>

#include <ogg/ogg.h>
#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>

#include <iostream>
using namespace std;
#if (HAVE_OGG)

Tagger_VorbisComment::Tagger_VorbisComment(vorbis_comment *vc) {
    comments.clear();
    for (int i = 0; i < vc->comments; i++) {
        /* Validation: basically, we assume a comment
         * if it has an '=' after one or more valid characters,
         * as the comment spec requires. We
         * also restrict ourselves to 0-terminated values 
         */
        *(vc->user_comments[i]+vc->comment_lengths[i]) = '\0';
        QString s = QString::fromUtf8(vc->user_comments[i]);
        if (s.find('=') == -1)
            continue; //skip this comment
        //   fix for ogg fields in uppercase
        QString tag = s.section('=',0,0);
        comments[tag.lower()] = s.section('=',1,1);
    }
}

#endif // HAVE_OGG

#if (HAVE_FLAC)

Tagger_VorbisComment::Tagger_VorbisComment(FLAC::Metadata::VorbisComment *vc) {
    comments.clear();
    for (int i = 0; i < vc->get_num_comments(); i++) {
        char buff[4095];

        /* Validation: basically, we assume a comment
        * if it has an '=' after one or more valid characters,
        * as the comment spec requires. We
        * also restrict ourselves to 0-terminated values 
        */
        FLAC::Metadata::VorbisComment::Entry entry = vc->get_comment(i);

        if (entry.get_field_length() > sizeof(buff)-1)
            continue;

        memcpy(buff, entry.get_field(), entry.get_field_length());

        *(buff+entry.get_field_length()) = '\0';
        QString s = QString::fromUtf8(buff);
        if (s.find('=') == -1)
            continue; //skip this comment
        //   fix for ogg fields in uppercase
        QString tag = s.section('=',0,0);
        comments[tag.lower()] = s.section('=',1,1);
    }
}
#endif // HAVE_FLAC


Tagger_VorbisComment::~Tagger_VorbisComment() {}

QString  Tagger_VorbisComment::getvorbiscomment( char *tag ) {
    QString result;

    if (comments.contains(tag))
        result = comments[tag];
    else
        result = QString::null;
    return result;
}
#endif // HAVE_OGG || HAVE_FLAC
