/**
 ** Proll (PROM replacement)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#include <stdarg.h>

// #include <asm/contregs.h>
#include <asi.h>
#include "pgtsrmmu.h"
#include "iommu.h"		/* Typical SBus IOMMU for sun4m */
#include "phys_jj.h"
#include "vconsole.h"
#include "version.h"
#include <general.h>		/* __P() */
#include <net.h>		/* init_net() */
#include <romlib.h>		/* we are a provider for part of this. */
#include <netpriv.h>		/* myipaddr */
#include <arpa.h>
#include <system.h>		/* our own prototypes */

void init_idprom(void);

struct vconterm dp0;
struct mem cmem;		/* Current memory, virtual */
struct mem cio;			/* Current I/O space */
struct phym pmem;		/* Current phys. mem. */
struct iommu ciommu;		/* Our IOMMU on sun4m */

static char *hw_idprom;

/*
 */
void prolmain()
{
	static char fname[14] = "00000000.PROL";
	static struct banks bb;
	int nmegs;
	int i;
	unsigned int hiphybas;
	void *romvec;

	vcon_init(&dp0, PHYS_JJ_TCX_FB);
	printk("PROLL %s MrCoffee\n", PROLL_VERSION_STRING);

	get_banks_layout(&bb, BANKS_JJ);
	if (bb.nbanks <= 0) {
		printk("No memory found\n");
		return;
	} else {
		nmegs = 0;
		for (i = 0; i < bb.nbanks; i++) {
			printk("bank %d 0x%x[0x%x]\n", i,
			    bb.bankv[i].start, bb.bankv[i].length);
			nmegs += bb.bankv[i].length/(1024*1024);
		}
		printk("%d MB total\n", nmegs);
	}

	i = bb.nbanks - 1;
	hiphybas = bb.bankv[i].start + bb.bankv[i].length - PROLSIZE;
	/* printk("high phys base 0x%x\n", hiphybas); */ /* P3 */

	/*
	 * We generate tables and switch two times.
	 * We start off being in low physical memory (LOADBASE) and
	 * mapped to high virtual (PROLBASE), running off PROM tables.
	 * These tables are located somewhere in upper physical so
	 * when we copy ourselves up we may step on them. The
	 * solution is to create temporary pages in low physical memory,
	 * then use them to move ourselves high. After that we may
	 * create new tables in high physical memory.
	 */

	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, LOADBASE);
#if 0
	proc_tablewalk(0, PROLBASE+PROLSIZE-PAGE_SIZE);
	mem_tablewalk((pmem.pctp[0]&(~0xF))<<4, PROLBASE+PROLSIZE-PAGE_SIZE);
#endif
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + LOADBASE);
	move_phys_high(hiphybas, PROLSIZE);
	/*
	 * We did not use the dynamic memory for anything but
	 * page tables, which are left down in low memory. Reinitiate cmem.
	 */
	mem_fini(&cmem);
	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, hiphybas);
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + hiphybas);

	mem_init(&cio, (char *)(PROLBASE+PROLSIZE),
	    (char *)(PROLBASE+PROLSIZE+IOMAPSIZE));

	iommu_init(&ciommu, hiphybas);

	/*
	 */
	init_idprom();
	sched_init();
	le_probe();
	init_net();

#if 0 /* RARP */
	if (rarp() != 0) fatal();
	/* printrarp(); */
	xtoa(myipaddr, fname, 8);
	if (load(servaddr, fname) != 0) fatal();
#else
	if (bootp() != 0) fatal();
	/*
	 * boot_rec.bp_file cannot be used because system PROM
	 * uses it to locate ourselves. If we load from boot_rec.bp_file,
	 * we will loop reloading PROLL over and over again.
	 * Thus we use traditional PROLL scheme HEXIPADDR.PROL (single L).
	 */
	xtoa(myipaddr, fname, 8);
	if (load(boot_rec.bp_siaddr, fname) != 0) fatal();
#endif

	romvec = init_openprom(bb.nbanks, bb.bankv, hiphybas);

	printk("Memory used: virt 0x%x:0x%x[%dK] iomap 0x%x:0x%x\n",
	    PROLBASE, (int)cmem.curp, ((unsigned) cmem.curp - PROLBASE)/1024,
	    (int)cio.start, (int)cio.curp);
	set_timeout(5);  while (!chk_timeout()) { }  /* P3: let me read */

	{
		void (*entry)(void *, int) = (void (*)(void*, int)) LOADBASE;
		entry(romvec, 0);
	}

	mem_fini(&cmem);
	vcon_fini(&dp0);
}

/*
 * dvma_alloc over iommu_alloc.
 */
void *dvma_alloc(int size, unsigned int *pphys)
{
	return iommu_alloc(&ciommu, size, pphys);
}

/*
 */
void udelay(unsigned long usecs)
{
	int i, n;
	n = usecs*50;
	for (i = 0; i < n; i++) { }
}

void init_idprom()
{
	char *va_prom;

	if ((va_prom = map_io(PHYS_JJ_EEPROM, PHYS_JJ_EEPROM_SIZE)) == NULL) {
		printk("init_idprom: cannot map eeprom\n");
		fatal();
	}
	bcopy(va_prom + PHYS_JJ_IDPROM_OFF, idprom, IDPROM_SIZE);
	/*
	 * hw_idprom is not used anywhere.
	 * It's just as we hate to leave hanging pointers (I/O page here).
	 */
	hw_idprom = va_prom; 
}
