/**
 ** Proll (PROM replacement)
 ** pcic.c: Functions for DVMA management in PCIC (simple DMA actually).
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#include <stdarg.h>
#include <crs.h>
#include <asi.h>

/* #include <linux/pci.h> */
#define PCI_VENDOR_ID           0x00    /* 16 bits */
#define PCI_DEVICE_ID           0x02    /* 16 bits */
#define PCI_COMMAND             0x04    /* 16 bits */
#define PCI_BASE_ADDRESS_0      0x10    /* 32 bits */

#define PCI_VENDOR_ID_SUN               0x108e

#include "pgtsrmmu.h"
#include "pcic.h"		/* PCIC definitions */
#include "phys_jk.h"
#include "vconsole.h"

#include <general.h>		/* __P() */
#include <romlib.h>		/* we are a provider for part of this. */
#include <system.h>		/* our own prototypes */

/*
 * XXX This is a problematic interface. We alloc _memory_ which is uncached.
 * So if we ever reuse allocations somebody is going to get uncached pages.
 * Returned address is always aligned by page.
 * BTW, we were not going to give away anonymous storage, were we not?
 */
void *pcic_alloc(struct pcic *t, int size, unsigned int *pphys)
{
	void *va;
	unsigned int pa, ba;
	unsigned int npages;
	unsigned int mva, mpa;
	int i;

	npages = (size + (PAGE_SIZE-1)) / PAGE_SIZE;
	va = mem_alloc(&cmem, npages*PAGE_SIZE, PAGE_SIZE);
	if (va == 0) return 0;
	pa = ((unsigned int)va) - PROLBASE + pmem.pbas;
	ba = pa;

	/*
	 * Change page attributes in MMU to uncached.
	 */
	mva = (unsigned int) va;
	mpa = (unsigned int) pa;
	for (i = 0; i < npages; i++) {
		map_page(pmem.pl1, mva, mpa, 1, pmem.pbas);
		mva += PAGE_SIZE;
		mpa += PAGE_SIZE;
	}

	*pphys = ba;
	return va;
}

/*
 * Initialize PCIC.
 * We disable IOTLB, so that PCI masters see DRAM addresses.
 */
void pcic_init(struct pcic *t, unsigned int highbase)
{
	unsigned n;

	t->regs = PHYS_JK_PCIC;

	n = ld_bp_swap(t->regs + PCI_VENDOR_ID);
	if (n != ((PCI_DEVICE_ID_SUN_PCIC2EP<<16)|PCI_VENDOR_ID_SUN)) {
		printk("PCIC: bad header %x/%x\n", n & 0xFFFF, n >> 16);
		for (;;) { }
	}

        /*
         * Switch off IOTLB translation.
         */
	stb_bypass(t->regs+PCI_DVMA_CONTROL, PCI_DVMA_CONTROL_IOTLB_DISABLE);

        /*
         * Make PCIC recognise 0-256MB window for DMA accesses.
         * Should be done in that order (size first, address second).
         */
        st_bp_swap(t->regs+PCI_SIZE_0, 0xF0000000UL);
	st_bypass(t->regs+PCI_BASE_ADDRESS_0, 0);

	/* printk("PCIC: initialized\n"); */
}

/*
 * In PCIC bus address equals to physical address of the memory
 * because we disable IOTLB and do not do any translations.
 */
unsigned long pcic_virt_to_bus(volatile void *addr)
{
	return ((unsigned int)addr) - PROLBASE + pmem.pbas;
}

/*
 * PCIC specific interface.
 */
void pcic_map_irq(struct pcic *t, unsigned pin, unsigned irq)
{
	unsigned int ivec, shift;
	unsigned int vaddr;

	if (pin >= 8 || irq >= 15) return;
	if (pin < 2) {
		vaddr = t->regs + PCI_INT_SELECT_LO;
		shift = (pin << 2) + 8;
	} else if (pin < 4) {
		vaddr = t->regs + PCI_INT_SELECT_LO;
		shift = (pin-2) << 2;
	} else if (pin < 6) {
		vaddr = t->regs + PCI_INT_SELECT_HI;
		shift = ((pin-4) << 2) + 8;
	} else {
		vaddr = t->regs + PCI_INT_SELECT_HI;
		shift = (pin-6) << 2;
	}
	ivec = ldh_bypass(vaddr);
	ivec &= ~(0xF << shift);
	ivec |= irq << shift;
	sth_bypass(vaddr, ivec);
}
