/*
 * Implmentation of RARP for Proll, thereby compatible
 * with Gero's packet driver code up to formatting style.
 * Copyright 1999 Pete Zaitcev
 * See accompaining document 'COPYING' for details.
 */
#include <general.h>
#include <romlib.h>
#include <net.h>
#include "netpriv.h"
#include "arp.h"

/*
 * Almost Gero's packet, but with char strings instead of long's.
 */
struct rarp_eth_packet {
  unsigned short  ar_hrd;                 /* format of hardware address   */
  unsigned short  ar_pro;                 /* format of protocol address   */
  unsigned char   ar_hln;                 /* length of hardware address   */
  unsigned char   ar_pln;                 /* length of protocol address   */
  unsigned short  ar_op;                  /* ARP opcode (command)         */
  unsigned char   ar_sha[ETH_ALEN];       /* sender hardware address      */
  unsigned char   ar_spa[IP_ALEN];        /* sender IP address            */
  unsigned char   ar_tha[ETH_ALEN];       /* target hardware address      */
  unsigned char   ar_tpa[IP_ALEN];        /* target IP address            */
};

static char *writebuf;
static volatile char rarp_open;

/*
 */
static int rarp_recv(buf, bufsize, addr)
unsigned char *buf;
int            bufsize;
unsigned char *addr;
{
  /* XXX We duplicate alignment problem which Gero introduced at x86 */
  struct rarp_eth_packet *ahp = (struct rarp_eth_packet *)buf;

  if (bufsize < sizeof(struct arphdr) ||
      ahp->ar_hrd != htons(ARPHRD_ETHER) || ahp->ar_hln != ETH_ALEN ||
      ahp->ar_pro != htons(ETH_P_IP) || ahp->ar_pln != IP_ALEN)
        return(0);
  if (!rarp_open)
	return(0);

  if (ahp->ar_op != htons(ARPOP_RREPLY))
	return(0);

  if (memcmp(ahp->ar_tha, myhwaddr, ETH_ALEN) != 0)
	return(0);

  if_config(ntohl(ld4(ahp->ar_tpa)), IP_ANY);
  servaddr = ntohl(ld4(ahp->ar_spa));
printk("rarp_recv: client 0x%x server 0x%x\n", myipaddr, servaddr);  /* P3 */

  rarp_open = 0;
  return(0);
}

/*
 */
int rarp()
{
  struct rarp_eth_packet abuf;

  if_config(IP_ANY, IP_CLASS_A);
  servaddr = IP_ANY;

  if (writebuf == NULL &&
     (writebuf = reg_type(htons(ETH_P_RARP), rarp_recv)) == NULL)
	return(-1);

  rarp_open = 1;

  /*
   * Send a request
   */
  abuf.ar_hrd = htons(ARPHRD_ETHER);
  abuf.ar_pro = htons(ETH_P_IP);
  abuf.ar_hln = ETH_ALEN;
  abuf.ar_pln = IP_ALEN;
  abuf.ar_op = htons(ARPOP_RREQUEST);
  memcpy(abuf.ar_sha, myhwaddr, ETH_ALEN);
  memset(abuf.ar_spa, 0, IP_ALEN);
  memcpy(abuf.ar_tha, myhwaddr, ETH_ALEN);
  memset(abuf.ar_tpa, 0, IP_ALEN);
  memcpy(writebuf, (char *)&abuf, sizeof(abuf));
  write_packet(sizeof(struct rarp_eth_packet), htons(ETH_P_RARP), bcasthw);

  set_timeout(10);
  for(;;) {
	if(chk_timeout()) {
		printk("RARP timeout\n");
		rarp_open = 0;
		return(-1);
	}
	if(!rarp_open) break;
  }

  return(0);
}
