#Kube CSS Framework

##What is Kube

Kube ("kyu:b") is a web framework for professional developers and designers alike. Kube is built and designed to provide the most flexible yet powerful CSS framework to the community. Unlike many other web frameworks, Kube is great for both super-fast 
bootstrapping and for a serious cutting edge, future-proof web development.

Kube is a wireframe, a skeleton for your project, in a way. It doesn’t impose design styles or code decisions; it does require fluency and proficiency with latest HTML and CSS technologies, though.

##Why Kube

There are many different reasons why thousands of professional developers and designers worldwide choose Kube for their projects. For one, Kube is only 32Kb, which is quite impressive considering what it can do for you. Another thing is that it is completely up to the developers and designers whether or not to fully embrace Kube’s minimalistic style, or expand and extend it to, well, pretty much any scale.


##Basic Template 

With Kube, you can set up your web framework and be on your way in under a minute. Just add this code to your web page for the basic template to take effect immediately.

```html
<!DOCTYPE html>
<html>
<head>
    <title>Basic Template</title>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Kube CSS -->
    <link rel="stylesheet" href="assets/css/kube.css">

</head>
<body>
    <h1>Hello, world!</h1>

    <!-- Kube JS + jQuery are used for some functionality, but are not required for the basic setup -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    <script src="assets/js/kube.js"></script>
</body>
</html>
```

##Supported Browsers 

Kube supports the latest, stable releases of all major browsers:

- Latest Chrome
- Latest Firefox
- Latest Safari
- Latest Opera
- Microsoft Edge
- Internet Explorer 11

##Quick Start
- [Quick Start Guide](https://imperavi.com/kube/docs/started/) — Setup in under a minute
- [Developing with Kube](https://imperavi.com/kube/docs/started/#h-development) — Getting started with custom development
- [Theming](https://imperavi.com/kube/docs/started/#h-theming) — Easily create custom styles and themes

##License
You have our permission to use Kube in whatever projects you wish commercial, for sale, or otherwise, in whichever way you like. Official license information can be find in [LICENSE.md](LICENSE.md) (spoiler: it's the MIT License)
