#!/bin/bash

arch=$(arch)
if [ $arch == "ppc" ]; then
    echo Sorry, PowerPC \(PPC\) is not supported...
else
    echo Compiling 64-bit binary, please wait...
    
    rm release/macos/protracker-osx.app/Contents/MacOS/protracker &> /dev/null
    
    clang -mmacosx-version-min=10.6 -arch x86_64 -mmmx -mfpmath=sse -msse2 -I/Library/Frameworks/SDL2.framework/Headers -F/Library/Frameworks src/gfx/*.c src/*.c -O3 -lm -Wall -Winit-self -Wextra -Wunused -Wredundant-decls -Wswitch-default -framework SDL2 -framework Cocoa -lm -o release/macos/protracker-osx.app/Contents/MacOS/protracker
    strip release/macos/protracker-osx.app/Contents/MacOS/protracker
    install_name_tool -change @rpath/SDL2.framework/Versions/A/SDL2 @executable_path/../Frameworks/SDL2.framework/Versions/A/SDL2 release/macos/protracker-osx.app/Contents/MacOS/protracker
    
    rm src/gfx/*.o src/*.o &> /dev/null
    echo Done! The executable is in the folder named \'release/macos\'.
fi
