/******************************************************************************
 fltk prozilla - a front end for prozilla, a download accelerator library
 Copyright (C) 2001 Kalum Somaratna

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/
#if HAVE_CONFIG_H
#  include <config.h>
#endif

#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Group.H>	// Fl_Group header file
#include <FL/fl_ask.H>		// FLTK convenience functions
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Browser.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/x.H>

#    ifdef HAVE_LIBXPM
#      include <X11/xpm.h>
#      include "images/Pz12.xpm"
#    endif


#include "prozilla.h"

#include "download_win.h"
#include "main.h"
#include "init.h"
#include "we.h"
#include "options.h"
#include "prefs.h"
#include "getopt.h"
#include "savefile.h"

struct runtime rt;
Fl_Hold_Browser *browser = 0;


/* structure for options parsing,
   currently doesnt contain anything
*/

struct option long_opts[] = {
  {0, 0, 0, 0}
};


void open_new_dl_win(urlinfo * url_data, boolean ftpsearch);
void menu_download_start();
void menu_download_stop();
void menu_download_remove();

class Main_Window:public Fl_Window {
public:
  Main_Window::Main_Window(int w, int h, const char *l);
  int handle(int);

};

Main_Window::Main_Window(int w, int h, const char *l):Fl_Window(w, h, l)
{

}

int Main_Window::handle(int e)
{

  if (e == FL_PASTE)
  {
    //    printf("%s\n", Fl::event_text());
    return 1;
  }

  if (Fl_Window::handle(e))
    return 1;

  return 0;
}



Main_Window *window;
Fl_Window *url_input_win;


DL_Window **dl_wins = NULL;
int num_dl_wins = 0;

Fl_Menu_Bar *menubar;
//Fl_Input *new_url;
//Fl_Output *t1;


void ms(const char *msg, void *cb_data)
{

  DL_Window *win = (DL_Window *) cb_data;
  win->browser->add(msg, 0);
  if (win->browser->size() > 0)
    win->browser->bottomline(win->browser->size());

}


void info_callback(void *)
{

  int i;

//  Fl::paste(*window);

  for (i = 0; i < num_dl_wins; i++)
  {
    dl_wins[i]->my_cb();
  }

  Fl::repeat_timeout(0.05, info_callback, 0);
}



void open_new_url()
{

  in_url->value("");
  do_ftpsearch_button->value(rt.use_ftpsearch==TRUE?1:0);
  url_input_win->show();
  /*
     val = fl_input(_("Enter URL (CTRL+V to paste from clipboard)"), 0);
     if (val == 0)
     {
     return;
     // User entered a string - go find it!
     //    strcpy(search, val);
     //    find2_cb();
     //  t1->value(val);
     }

     err = proz_parse_url(val, url_data, 0);
     if (err != URLOK)
     {
     fl_message(_("%s does not seem to be a valid URL"), val);
     return;
     }
     open_new_dl_win(url_data);

   */
}


void paste_new_url(char *url)
{

}


void open_new_dl_win(urlinfo * url_data, boolean ftpsearch)
{
  num_dl_wins++;
  dl_wins =
    (DL_Window **) realloc(dl_wins,
			   (sizeof(DL_Window **) * num_dl_wins));

  dl_wins[num_dl_wins - 1] =
    new DL_Window(url_data, FL_DOWN_BOX, 70, 70, "");

  dl_wins[num_dl_wins - 1]->label(strdup(url_data->url));

  dl_wins[num_dl_wins - 1]->show();

  /*Search and see if DL is already in list */
  boolean in_list=FALSE;

    for (int i=0;i<browser->size();i++)
      {
	if(strcmp(url_data->url, browser->text(i+1))==0)
	{	 
	  in_list=TRUE;
	}
      }
  if(in_list==FALSE)
    {
      /*Add the URL to the browser if not already in list*/
      browser->add(url_data->url, 0);
    }

  dl_wins[num_dl_wins - 1]->dl_start(4, ftpsearch);

}



void show_prefs()
{
  pref_panel_setup();
  rt.prefs_win->show();
}

void show_about()
{
  win_about->show();
}


void quit_cb(Fl_Widget *, void *)
{
  create_savefile(browser);
  exit(0);
}


/*Callback for the ok button that appears in the open new url dialog*/
void cb_url_input_ok(Fl_Return_Button * button, void *data)
{
  uerr_t err;
  urlinfo *url_data;

  url_data = (urlinfo *) malloc(sizeof(urlinfo));
  memset(url_data, 0, sizeof(urlinfo));

  err = proz_parse_url(in_url->value(), url_data, 0);
  if (err != URLOK)
    {
      fl_message(_("%s does not seem to be a valid URL"), in_url->value());
      return;
    }

  /*Search and see if DL is already in list */

  for (int i=0;i<browser->size();i++)
    {
      if(strcmp(url_data->url, browser->text(i+1))==0)
	{
	  fl_message(_("%s is already in the list of downloads"), in_url->value());
	  return;
	}
    }

  /*Search and se eif DL is already running*/
  for (int i = 0; i < num_dl_wins; i++)
    {
      if(strcmp( url_data->url,dl_wins[i]->u.url)==0)
	{
	  if(dl_wins[i]->status!=  DL_ABORTED &&
	     dl_wins[i]->status!=DL_FATALERR &&
	     dl_wins[i]->status!=DL_IDLING)
	    {
	      fl_message(_("%s is already running!"), in_url->value());
	      return;
	    }
	}
    }

  if (strlen(url_data->file) == 0)
    {
      fl_message(_
		 ("%s contains just a hostname, it does not contain a file to download!"),
		 url_data->url);
      return;
    }

  open_new_dl_win(url_data, do_ftpsearch_button->value());

  url_input_win->hide();

}

/*Callback for the cancel button that appears in the open new url dialog*/
void cb_url_input_cancel(Fl_Button * button, void *data)
{
  url_input_win->hide();
}


void cb_main_win(Fl_Window * widget, void *)
{
  quit_cb(widget, 0);
}



    /* kov: FIXME?:
       I brought this here because it was not being affected by gettext 
     */
    Fl_Menu_Item menuitems[] = {
      {_("&File"), FL_CTRL + 'F', 0, 0, FL_SUBMENU},
      {_("&New URL"), FL_CTRL + 'N', (Fl_Callback *) open_new_url,
       (void *) 0},
      {_("&Preferences"), FL_CTRL + 'P', (Fl_Callback *) show_prefs,
       (void *) 0},
      {_("&Quit"), FL_CTRL + 'q', quit_cb, (void *) 0},
      {0},
      {_("&Download"), FL_CTRL + 'D', 0, 0, FL_SUBMENU},
      {_("&Start"), FL_CTRL + 'S', (Fl_Callback *) menu_download_start, (void *) 0, FL_MENU_INACTIVE},
      {_("&Stop"), FL_CTRL + 'P', (Fl_Callback *) menu_download_stop, (void *) 0, FL_MENU_INACTIVE},
      {_("&Remove from list"), FL_CTRL + 'R', (Fl_Callback *) menu_download_remove, (void *) 0, FL_MENU_INACTIVE},
      {0},
      {_("&Help"), FL_CTRL + 'H', 0, 0, FL_SUBMENU},
      {_("&About"), FL_CTRL + 'A', (Fl_Callback *) show_about, (void *) 0},
      {0},
      {0}
    };


void menu_download_start()
{
  int select=browser->value();
  boolean running=FALSE;

  int i;
  /*Search and se eif DL is in list */
  for ( i = 0; i < num_dl_wins; i++)
    {
      if(strcmp(dl_wins[i]->u.url, browser->text(select))==0)
	{
	  if(dl_wins[i]->status!=  DL_ABORTED &&
	     dl_wins[i]->status!=DL_FATALERR &&
	     dl_wins[i]->status!=DL_IDLING)
	  running=TRUE;
	}
    }

  if(running==TRUE)
    {
      /*what to do if it is in the list of already started dl's */
      return;
    }
  else
    {
      /*Ok lets start it then */
      uerr_t err;
      urlinfo *url_data;

      url_data = (urlinfo *) malloc(sizeof(urlinfo));
      memset(url_data, 0, sizeof(urlinfo));

      err = proz_parse_url(browser->text(select), url_data, 0);
      if (err != URLOK)
	{
	  fl_message(_("%s does not seem to be a valid URL"), in_url->value());
	  return;
	}

      if (strlen(url_data->file) == 0)
	{
	  fl_message(_
		     ("%s contains just a hostname, it does not contain a file to download!"),
		     url_data->url);
	  return;
	}

      open_new_dl_win(url_data, rt.use_ftpsearch);
    }
}

void menu_download_stop()
{
  int select=browser->value();
}

void menu_download_remove()
{
  int select=browser->value();
  browser->remove(select);
     menuitems[6].deactivate();
     menuitems[7].deactivate();
     menuitems[8].deactivate();
}

void browser_cb(Fl_Widget * o, void *)
{
/* printf("callback, selection = %d, event_clicks = %d\n",
	 ((Fl_Browser*)o)->value(), Fl::event_clicks()); */
 /* Now to enable the menus */

 int value=((Fl_Browser*)o)->value();

if(value==0)
   {
     /*Check and enable the menus appropriately */
     menuitems[6].deactivate();
     //     menuitems[7].deactivate();
     menuitems[8].deactivate();
   }

 if(value>0)
   {
     /*Check and enable the menus appropriately */
     menuitems[6].activate();
     //     menuitems[7].activate();
     menuitems[8].activate();
   }
}

int main(int argc, char **argv)
{
  int c;
#ifndef FL_NORMAL_SIZE
  FL_NORMAL_SIZE = 12;
#endif

  /* kov: 
     This function has to come before the gettext stuff
     as it is making it ineffective
   */
  proz_init(argc, argv);

  /* Gettext stuff */
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);

  set_defaults(&argc, &argv);
  load_prefs();
  set_runtime_values();

  /*delete the ~/.prozilla/debug.log file if present at the start of each run */
  proz_debug_delete_log();

  /*Parse options */
  while ((c = getopt_long(argc, argv, "", long_opts, NULL)) != EOF)
  {
    switch (c)
    {
    default:
      printf(_("Error: Invalid  option\n"));
      exit(0);
    }
  }

  window = new Main_Window(500, 340, _("Prozilla - Download Accelerator"));

#ifdef HAVE_LIBXPM		// X11 w/Xpm library
  fl_open_display();
  Pixmap pixmap, mask;		// Icon pixmaps
  XpmAttributes attrs;		// Attributes of icon

  memset(&attrs, 0, sizeof(attrs));

  XpmCreatePixmapFromData(fl_display, DefaultRootWindow(fl_display),
			  Pz12_xpm, &pixmap, &mask, &attrs);
  window->icon((char *) pixmap);

#endif

  Fl_Menu_Bar *menubar = new Fl_Menu_Bar(0, 0, 640, 30);
  menubar->labelfont(FL_TIMES);

  {
    //NOTE Removed the menu to place above...

    menubar->menu(menuitems);
  }

  /*The browser window */
  browser = new Fl_Hold_Browser(2, 250, 495, 80);
  browser->callback(browser_cb);
  load_savefile(browser);
  rt.prefs_win = make_prefs_win();
  win_about = make_about_win();
  window->callback((Fl_Callback *) cb_main_win, 0);
  window->show(1, argv);

  url_input_win = make_url_input_win();

  /* we will now see whether the user has specfied any urls in the command line  and add them */
  for (int i = optind; i < argc; i++)
  {
    uerr_t err;
    urlinfo *url_data;
    url_data = (urlinfo *) malloc(sizeof(urlinfo));
    memset(url_data, 0, sizeof(urlinfo));

    err = proz_parse_url(argv[i], url_data, 0);
    if (err != URLOK)
    {
      printf(_("%s does not seem to be a valid URL"), argv[optind]);
      proz_debug("%s does not seem to be a valid URL", argv[optind]);
      exit(0);
    }

    open_new_dl_win(url_data,rt.use_ftpsearch);
  }

  Fl::add_timeout(0.4, info_callback, 0);
  return Fl::run();
}
