#ifndef CHATVIEW_H
#define CHATVIEW_H

#include <QWidget>
#include <QDateTime>
#include <QFrame>
#include "webview.h"
#include "chatviewbase.h"

class ChatEdit;

class ChatView : public QFrame, public ChatViewBase
{
	Q_OBJECT
public:
	ChatView(QWidget* parent);
	~ChatView();

	// reimplemented
	QSize sizeHint() const;
	void setFont(const QFont &);
	void contextMenuEvent(QContextMenuEvent* event);

	void importJSChatFunctions();
	void markReceived(QString id);

	void appendText(QString text);
	bool handleCopyEvent(QObject *object, QEvent *event, ChatEdit *chatEdit);

	void appendMucMessage(bool local, const QString &text, bool emote, const QString &nick, const QDateTime &time, const QString &nickcolor, bool alert);
	void appendMessage(const QString &id, bool local, const QString &text, bool emote, const QString &nick, const QDateTime &time, const QString &color, bool remember, const QString &subject);
	void appendSysMessage(const QString &text, const QString &userText = "", const QDateTime &time = QDateTime::currentDateTime());
	void appendLastMsgTime(const QDate &date);

	void appendSubject(const QString &subject);
	void appendMucSubject(const QString &sysMsg, const QString &subject, const QDateTime &time);
	void startUrlsBlock();
	void appendUrl(const QString &url, const QString &desc);

	void scrollUp();
	void scrollDown();
	void scrollToBottom();
	void clear();
	void doTrackBar();
	bool internalFind(QString str, bool startFromBeginning = false);
	WebView * textWidget();

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	//void keyPressEvent(QKeyEvent *);

protected slots:
	void autoCopy();

signals:
	void showNM(QString);

private:
	WebView *webView;
};

#endif
