#ifndef Http_H
#define Http_H
// VERSION 1.1
#include <QtNetwork>
/// класс релизации http протокола с поддержкой передачи переменных (GET,POST,cookie)
class Http: public QTcpSocket
{
		QString _host;	
		quint16 _port;
		QString _proxy_addr;
		quint16 _proxy_port;
		bool _follow_moving; //< следовать ли перенаправлению (false)
		int _lastQueryResultCode; //<результат выполнения последнего запроса
		QMap <QString,QString> _cookies;
		QMap <QString,QString> _text_variables;
		QMap <QString,QString> _header_variables;
		QMap <QString,QString> _files;
		
		QByteArray makeHeader(const QString &url,QString method);//< создает заголовок.		
                QString cookies(); //< возвращает строку с кукисами.
		void splitCoockie(const QStringList &header);
		QByteArray sendQuery(const QByteArray &header); //< посылает запрос с заголовком header
		QByteArray joinVariables(); //< объединить переменные в запрос.
                QString headerParam(const QString &header, const QString name); //< возвращает параметр из заголовка.
	public:
		Http();
	
		void setHost(const QString &host,quint16 port=80);//< устанавливает адрес и порт сервера для соединения.
                void addCookie(const QString &name,const QString &value);//< добавляет переменную куки (если такая имеется, то он перезаписывается).
		void addHeaderVariable(const QString &name,const QString &value);//< устанавливает переменную заголовка (если такая имеется, то он перезаписывается).
		void removeHeaderVariable(const QString &name);
                QString cookie(const QString &name); //< возвращает значение куки по имени.
		QByteArray get(const QString &url);//< отправить get запрос.
		/*! обработка заголовка ответа.
		 * \param answer содержание ответа.
		 */
		QByteArray processAnswer(const QByteArray &answer);
                QByteArray followMoving(const QString &header);
		int lastQueryResultCode();//< возвращает результат выполнения последнего запроса
                //void setContentType(const QString &ct); //< установить тип содержимого.
		void setFollowMoving(bool f); //< следовать ли перенаправлению если получен код 302
		bool isUsingProxy(); //< используем ли прокси.
}; 


#endif
