#include "invitedialog.h"

InviteDialog::InviteDialog(QStringList resources, QWidget *parent)
        :  QDialog(parent)
        , resources_(resources)
{
    setAttribute(Qt::WA_DeleteOnClose);
    ui_.setupUi(this);
    ui_.cb_resource->setEditable(true);
    if(!resources.isEmpty()) {
        ui_.cb_resource->addItems(resources_);
    } else {
        ui_.cb_resource->addItem("Enter resource");
    }

    connect(ui_.pb_black, SIGNAL(pressed()), this, SLOT(buttonPressed()));
    connect(ui_.pb_white, SIGNAL(pressed()), this, SLOT(buttonPressed()));

    adjustSize();
    setFixedSize(size());
}

void InviteDialog::buttonPressed()
{
    if(ui_.pb_white->isDown()) {
        emit play(ui_.cb_resource->currentText(), "white");
        close();
    }
    else if(ui_.pb_black->isDown()) {
        emit play(ui_.cb_resource->currentText(), "black");
        close();
    }
}



InvitationDialog::InvitationDialog(QString jid, QString color,  QWidget *parent)
        :  QDialog(parent)
{
    setAttribute(Qt::WA_DeleteOnClose);
    setModal(false);
    ui_.setupUi(this);
    accepted = false;

    if(color == "white")
	    color = tr("white");
    else
	    color = tr("black");

    ui_.lbl_text->setText(tr("Player %1 invites you \nto play chess. He wants to play %2.")
                          .arg(jid).arg(color));

    connect(ui_.pb_accept, SIGNAL(pressed()), this, SLOT(buttonPressed()));
    connect(ui_.pb_reject, SIGNAL(pressed()), this, SLOT(close()));

    adjustSize();
    setFixedSize(size());
}

void InvitationDialog::buttonPressed()
{
        emit accept();
        accepted = true;
        close();
}

void InvitationDialog::closeEvent(QCloseEvent *e)
{
    if(!accepted)
        emit reject();
    e->accept();
    close();
}
