#ifndef VIEWER_H
#define VIEWER_H

#include <QDialog>
#include <QCloseEvent>
#include <QDateTime>
#include <QTextEdit>

#include "iconfactoryaccessinghost.h"
#include "typeaheadfind.h"

class Viewer : public QDialog
{
    Q_OBJECT
    public:
        Viewer(QString filename, IconFactoryAccessingHost *IcoHost, QWidget *parent = 0);
        bool init();

    private:
        IconFactoryAccessingHost *icoHost_;
        QString fileName_;
        QDateTime lastModified_;
        QTextEdit *textWid;
        TypeAheadFindBar *findBar;
        QMap<int, QString> pages_;
        int currentPage_;
        void setPage();

    private slots:
        void saveLog();
        void updateLog();
        void deleteLog();
        void nextPage();
        void prevPage();
        void firstPage();
        void lastPage();

    protected:
        void closeEvent(QCloseEvent *e);

    signals:
        void onClose(int,int);
};

#endif // VIEWER_H
